/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;

public class SearchContextTestUtil {
    public static SearchContext getSearchContext() throws Exception {
        return SearchContextTestUtil.getSearchContext(TestPropsValues.getGroupId());
    }

    public static SearchContext getSearchContext(long groupId) throws Exception {
        return SearchContextTestUtil.getSearchContext(TestPropsValues.getUserId(), new long[]{groupId}, "", null, null);
    }

    public static SearchContext getSearchContext(long userId, long[] groupIds, String keywords, Locale locale) throws PortalException {
        return SearchContextTestUtil.getSearchContext(userId, groupIds, keywords, locale, false);
    }

    public static SearchContext getSearchContext(long userId, long[] groupIds, String keywords, Locale locale, boolean highlightEnabled) throws PortalException {
        return SearchContextTestUtil.getSearchContext(userId, groupIds, keywords, locale, highlightEnabled, null);
    }

    public static SearchContext getSearchContext(long userId, long[] groupIds, String keywords, Locale locale, boolean highlightEnabled, Map<String, Serializable> attributes) throws PortalException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(TestPropsValues.getCompanyId());
        searchContext.setGroupIds(groupIds);
        searchContext.setKeywords(keywords);
        searchContext.setLocale(locale);
        searchContext.setUserId(userId);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(highlightEnabled);
        queryConfig.setSelectedFieldNames(new String[]{"*"});
        return searchContext;
    }

    public static SearchContext getSearchContext(long userId, long[] groupIds, String keywords, Locale locale, Map<String, Serializable> attributes) throws PortalException {
        return SearchContextTestUtil.getSearchContext(userId, groupIds, keywords, locale, false, attributes);
    }

    public static SearchContext getSearchContext(long userId, String keywords, Locale locale) throws PortalException {
        return SearchContextTestUtil.getSearchContext(userId, null, keywords, locale, null);
    }
}

