/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.search.facet.collector.TermCollector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.test.util.AssertUtils;
import com.liferay.portal.search.test.util.TermCollectorUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;

public class FacetsAssert {
    public static void assertFrequencies(String message, Facet facet, String expected) {
        FacetCollector facetCollector = facet.getFacetCollector();
        List termCollectors = facetCollector.getTermCollectors();
        Assert.assertNotNull((Object)termCollectors);
        Stream stream = termCollectors.stream();
        Assert.assertEquals((String)message, (Object)expected, (Object)stream.map(FacetsAssert::toString).collect(Collectors.toList()).toString());
    }

    public static void assertFrequencies(String facetName, SearchContext searchContext, Hits hits, Map<String, Integer> expected) {
        Map facets = searchContext.getFacets();
        Facet facet = (Facet)facets.get(facetName);
        FacetCollector facetCollector = facet.getFacetCollector();
        AssertUtils.assertEquals(StringBundler.concat((Object[])new Object[]{searchContext.getAttribute("queryString"), "->", StringUtil.merge((Object[])hits.getDocs())}), expected, TermCollectorUtil.toMap(facetCollector.getTermCollectors()));
    }

    public static void assertFrequencies(String facetName, SearchContext searchContext, List<String> expected) {
        FacetsAssert.assertFrequencies((String)((Object)searchContext.getAttribute("queryString")), searchContext.getFacet(facetName), String.valueOf(expected));
    }

    protected static String toString(TermCollector termCollector) {
        return termCollector.getTerm() + "=" + termCollector.getFrequency();
    }
}

