/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.sort;

import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.filter.ComplexQueryPartBuilderFactory;
import com.liferay.portal.search.internal.filter.ComplexQueryPartBuilderFactoryImpl;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.function.Consumer;
import org.junit.Test;

public abstract class BaseSortUnmappedFieldsTestCase
extends BaseIndexingTestCase {
    protected final ComplexQueryPartBuilderFactory complexQueryPartBuilderFactory = new ComplexQueryPartBuilderFactoryImpl();

    @Test
    public void testDefaultIsTextMappingWithEmptyResults() {
        String fieldName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this.addDocument(this.builder().setString(fieldName, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])));
        this.assertSearch(fieldName, "[]", new Consumer[0]);
    }

    @Test
    public void testDefaultOnNewIndexIsEmptyResults() {
        this.assertSearch(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), "[]", new Consumer[0]);
    }

    @Test
    public void testEmailAddressIsKeywordInLiferayTypeMappings() {
        this.addDocument(this.builder().setString("emailAddress", "dxp@liferay.com").setString("emailAddressDomain", "liferay.com"));
        this.assertSearch("emailAddress", "[dxp@liferay.com]", new Consumer[0]);
        this.assertSearch("emailAddress", "[]", this.withTerm("emailAddress", "dxp"));
        this.assertSearch("emailAddress", "[]", this.withTerm("emailAddress", "liferay.com"));
        this.assertSearch("emailAddress", "[dxp@liferay.com]", this.withTerm("emailAddress", "dxp@liferay.com"));
    }

    @Test
    public void testEmailAddressOnNewIndex() {
        this.assertSearch("emailAddress", "[]", new Consumer[0]);
    }

    @Test
    public void testFirstNameIsTextMappingWithEmptyResults() {
        this.addDocument(this.builder().setString("firstName", "Liferay DXP"));
        this.assertSearch("firstName", "[]", new Consumer[0]);
        this.assertSearch("firstName", "[]", this.withTerm("firstName", "Liferay DXP"));
    }

    @Test
    public void testFirstNameOnNewIndex() {
        this.assertSearch("firstName", "[]", new Consumer[0]);
    }

    @Test
    public void testFirstNameStringSortable() {
        this.addDocument(this.builder().setString("firstName", "Liferay DXP").setString("firstName_String_sortable", "Liferay DXP"));
        this.assertSearch("firstName_String_sortable", "[Liferay DXP]", new Consumer[0]);
        this.assertSearch("firstName_String_sortable", "[Liferay DXP]", this.withTerm("firstName", "dxp"));
        this.assertSearch("firstName_String_sortable", "[]", this.withTerm("firstName", "Liferay DXP"));
        this.assertSearch("firstName_String_sortable", "[]", this.withTerm("firstName_String_sortable", "dxp"));
        this.assertSearch("firstName_String_sortable", "[Liferay DXP]", this.withTerm("firstName_String_sortable", "Liferay DXP"));
    }

    @Test
    public void testFirstNameStringSortableOnNewIndex() {
        this.assertSearch("firstName_String_sortable", "[]", new Consumer[0]);
    }

    @Test
    public void testSortableKeyword() {
        String fieldName1 = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        String fieldName2 = fieldName1 + "_String_sortable";
        String fieldValue = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this.addDocument(this.builder().setString(fieldName1, fieldValue).setString(fieldName2, fieldValue));
        this.assertSearch(fieldName1, "[]", new Consumer[0]);
        this.assertSearch(fieldName2, "[" + fieldValue + "]", new Consumer[0]);
    }

    @Test
    public void testSortableNumber() throws Throwable {
        String fieldName1 = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        String fieldName2 = fieldName1 + "_Number_sortable";
        int fieldValue = RandomTestUtil.randomInt();
        this.addDocument(this.builder().setInteger(fieldName1, Integer.valueOf(fieldValue)).setInteger(fieldName2, Integer.valueOf(fieldValue)));
        this.assertSearch(fieldName1, "[]", new Consumer[0]);
        this.assertSearch(fieldName2, "[" + fieldValue + "]", new Consumer[0]);
    }

    protected void assertSearch(String fieldName, String expected, Consumer<SearchRequestBuilder> ... searchRequestBuilderConsumers) {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.sorts(new Sort[]{this.sorts.field(fieldName)}).withSearchRequestBuilder(searchRequestBuilderConsumers));
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> DocumentsAssert.assertValues(searchResponse.getRequestString(), searchResponse.getDocumentsStream(), fieldName, expected));
        });
    }

    protected DocumentBuilder builder() {
        return this.newDocumentBuilder();
    }

    protected Consumer<SearchRequestBuilder> withTerm(String fieldName, String term) {
        return searchRequestBuilder -> searchRequestBuilder.addComplexQueryPart(this.complexQueryPartBuilderFactory.builder().query((Query)this.queries.term(fieldName, (Object)term)).build());
    }
}

