/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.sort;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import com.liferay.portal.search.test.util.mappings.NestedDDMFieldArrayUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseNestedFieldsSortTestCase
extends BaseIndexingTestCase {
    @Test
    public void testSort1() throws Exception {
        this.assertSort("ddm__keyword__41523__Booleantua8_en_US_String_sortable");
    }

    @Test
    public void testSort2() throws Exception {
        this.assertSort("ddm__keyword__41523__Textggef_en_US");
    }

    @Test
    public void testSort3() throws Exception {
        this.assertSort("ddm__keyword__41523__Textp47b_en_US");
    }

    protected void addDocumentWithOneDDMField(String name, String valueFieldName, Object value) {
        this.addDocument(DocumentCreationHelpers.oneDDMField(name, valueFieldName, value));
    }

    protected void assertSort(String fieldName) {
        Stream.of("C", "B", "A").forEach(value -> this.addDocumentWithOneDDMField(fieldName, "ddmFieldValueKeyword", value));
        FieldSort fieldSort = this.sorts.field("ddmFieldArray.ddmFieldValueKeyword");
        fieldSort.setNestedSort(this.sorts.nested("ddmFieldArray"));
        String expected = "[A, B, C]";
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(this::fetchSourceIncludes);
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.sorts(new Sort[]{fieldSort}));
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> Assert.assertEquals((String)searchResponse.getRequestString(), (Object)expected, (Object)String.valueOf(this.getDDMFieldValues(fieldName, (SearchResponse)searchResponse))));
        });
    }

    protected SearchRequestBuilder fetchSourceIncludes(SearchRequestBuilder searchRequestBuilder) {
        return searchRequestBuilder.fetchSourceIncludes(new String[]{"ddmFieldArray.*"});
    }

    protected Object getDDMFieldValue(String fieldName, Document document) {
        List values = document.getValues("ddmFieldArray");
        Optional<Object> optional = NestedDDMFieldArrayUtil.getFieldValue(fieldName, values.stream());
        return optional.get();
    }

    protected List<?> getDDMFieldValues(String fieldName, SearchResponse searchResponse) {
        Stream stream = searchResponse.getDocumentsStream();
        return stream.map(document -> this.getDDMFieldValue(fieldName, (Document)document)).collect(Collectors.toList());
    }
}

