/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.sort;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.internal.SortFactoryImpl;
import com.liferay.portal.search.test.util.document.BaseDocumentTestCase;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseDocumentSortTestCase
extends BaseDocumentTestCase {
    private static final String[] _KEYWORDS = new String[]{"sixth second first fourth fifth third", "second first fourth fifth third sixth", "first fourth fifth third sixth second", "fourth fifth third sixth second first", "fifth third sixth second first fourth", "third sixth second first fourth fifth"};
    private static final String[] _KEYWORDS_ODD = new String[]{"first fifth third", "fifth third first", "third first fifth", "first third fifth", "fifth first third"};
    private static final String[] _SCREEN_NAMES_DOUBLE_ORDER = new String[]{"firstuser", "fourthuser", "seconduser", "fifthuser", "thirduser", "sixthuser"};
    private static final String[] _SCREEN_NAMES_FLOAT_ORDER = new String[]{"sixthuser", "fifthuser", "fourthuser", "thirduser", "seconduser", "firstuser"};
    private static final String[] _SCREEN_NAMES_INTEGER_ORDER = new String[]{"sixthuser", "fifthuser", "fourthuser", "thirduser", "seconduser", "firstuser"};
    private static final String[] _SCREEN_NAMES_LONG_ORDER = new String[]{"firstuser", "seconduser", "thirduser", "fourthuser", "fifthuser", "sixthuser"};
    private static final String[] _SCREEN_NAMES_ODD_DOUBLE_ORDER = new String[]{"firstuser", "fifthuser", "thirduser"};
    private static final String[] _SCREEN_NAMES_ODD_FLOAT_ORDER = new String[]{"fifthuser", "thirduser", "firstuser"};
    private static final String[] _SCREEN_NAMES_ODD_INTEGER_ORDER = new String[]{"fifthuser", "thirduser", "firstuser"};
    private static final String[] _SCREEN_NAMES_ODD_LONG_ORDER = new String[]{"firstuser", "thirduser", "fifthuser"};

    @Test
    public void testDoubleSort() throws Exception {
        this.assertSort("Smith", "sd", 7, _SCREEN_NAMES_DOUBLE_ORDER);
    }

    @Test
    public void testDoubleSortIgnoresScores() throws Exception {
        for (String keywords : _KEYWORDS) {
            this.assertSort(keywords, "sd", 7, _SCREEN_NAMES_DOUBLE_ORDER);
        }
        for (String keywords : _KEYWORDS_ODD) {
            this.assertSort(keywords, "sd", 7, _SCREEN_NAMES_ODD_DOUBLE_ORDER);
        }
    }

    @Test
    public void testFloatSort() throws Exception {
        this.assertSort("Smith", "sf", 5, _SCREEN_NAMES_FLOAT_ORDER);
    }

    @Test
    public void testFloatSortIgnoresScores() throws Exception {
        for (String keywords : _KEYWORDS) {
            this.assertSort(keywords, "sf", 5, _SCREEN_NAMES_FLOAT_ORDER);
        }
        for (String keywords : _KEYWORDS_ODD) {
            this.assertSort(keywords, "sf", 5, _SCREEN_NAMES_ODD_FLOAT_ORDER);
        }
    }

    @Test
    public void testIntegerSort() throws Exception {
        this.assertSort("Smith", "si", 4, _SCREEN_NAMES_INTEGER_ORDER);
    }

    @Test
    public void testIntegerSortIgnoresScores() throws Exception {
        for (String keywords : _KEYWORDS) {
            this.assertSort(keywords, "si", 4, _SCREEN_NAMES_INTEGER_ORDER);
        }
        for (String keywords : _KEYWORDS_ODD) {
            this.assertSort(keywords, "si", 4, _SCREEN_NAMES_ODD_INTEGER_ORDER);
        }
    }

    @Test
    public void testLongSort() throws Exception {
        this.assertSort("Smith", "sl", 6, _SCREEN_NAMES_LONG_ORDER);
    }

    @Test
    public void testLongSortIgnoresScores() throws Exception {
        for (String keywords : _KEYWORDS) {
            this.assertSort(keywords, "sl", 6, _SCREEN_NAMES_LONG_ORDER);
        }
        for (String keywords : _KEYWORDS_ODD) {
            this.assertSort(keywords, "sl", 6, _SCREEN_NAMES_ODD_LONG_ORDER);
        }
    }

    protected void assertSort(String keywords, Sort sort, String ... screenNames) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> searchContext.setSorts(new Sort[]{sort}));
            indexingTestHelper.setQuery(this.getQuery(keywords));
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> {
                ArrayList<String> searchResultValues = new ArrayList<String>(screenNames.length);
                ArrayList<String> screenNamesList = new ArrayList<String>(screenNames.length);
                for (int i = 0; i < hits.getLength(); ++i) {
                    Document document = hits.doc(i);
                    searchResultValues.add(document.get(sort.getFieldName()));
                    screenNamesList.add(document.get("screenName"));
                }
                Assert.assertEquals((String)StringUtil.merge(searchResultValues), (Object)StringUtil.merge((Object[])screenNames), (Object)StringUtil.merge(screenNamesList));
            });
        });
    }

    protected void assertSort(String keywords, String field, int type, String ... ascendingScreenNames) throws Exception {
        SortFactoryImpl sortFactory = new SortFactoryImpl();
        this.assertSort(keywords, sortFactory.create(field, type, false), ascendingScreenNames);
        Object[] descendingScreenNames = Arrays.copyOf(ascendingScreenNames, ascendingScreenNames.length);
        ArrayUtil.reverse((Object[])descendingScreenNames);
        this.assertSort(keywords, sortFactory.create(field, type, true), (String[])descendingScreenNames);
    }

    protected Query getQuery(String keywords) {
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        booleanQueryImpl.add((Query)new MatchQuery("firstName", keywords), BooleanClauseOccur.SHOULD);
        booleanQueryImpl.add((Query)new MatchQuery("lastName", keywords), BooleanClauseOccur.SHOULD);
        return booleanQueryImpl;
    }
}

