/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.MatchPhraseQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMatchPhraseQueryTestCase
extends BaseIndexingTestCase {
    private static final String _FIELD_NAME = "content";

    @Test
    public void testMatchQuery() {
        this.addDocuments("java eclipse", "java liferay", "liferay uses java for development", "C is the best language");
        this.assertSearch("liferay uses java", Arrays.asList("liferay uses java for development"));
    }

    protected void addDocuments(String ... values) {
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(_FIELD_NAME, value), Arrays.asList(values));
    }

    protected void assertSearch(Object value, List<String> expectedValues) {
        this.assertSearch(indexingTestHelper -> {
            MatchPhraseQuery matchPhraseQuery = this.queries.matchPhrase(_FIELD_NAME, value);
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames(new String[]{"_all"});
            searchSearchRequest.setQuery((Query)matchPhraseQuery);
            searchSearchRequest.setSize(Integer.valueOf(30));
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)expectedValues.size(), (long)searchHits.getTotalHits());
            List searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals((String)"Retrieved hits", (long)expectedValues.size(), (long)searchHitsList.size());
            ArrayList actualValues = new ArrayList();
            searchHitsList.forEach(searchHit -> {
                Document document = searchHit.getDocument();
                actualValues.add(document.getString(_FIELD_NAME));
            });
            Assert.assertEquals((String)("Retrieved hits ->" + actualValues), (Object)expectedValues.toString(), (Object)((Object)actualValues).toString());
        });
    }
}

