/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.MatchAllQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMatchAllQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testMatchAllQuery() {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        final MatchAllQuery matchAllQuery = this.queries.matchAll();
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)new SearchSearchRequest(){
                {
                    this.addSorts(new Sort[]{BaseMatchAllQueryTestCase.this.sorts.field("priority")});
                    this.setIndexNames(new String[]{"_all"});
                    this.setQuery((Query)matchAllQuery);
                    this.setSize(30);
                }
            });
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)20L, (long)searchHits.getTotalHits());
            List searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals((String)"Retrieved hits", (long)20L, (long)searchHitsList.size());
            for (int i = 0; i < 20; ++i) {
                SearchHit searchHit = (SearchHit)searchHitsList.get(i);
                Document document = searchHit.getDocument();
                Double priority = document.getDouble("priority");
                Assert.assertEquals((String)"Priority value", (double)((double)i + 1.0), (double)priority, (double)0.0);
            }
        });
    }

    @Test
    public void testMatchAllQueryWithSize0() {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        this.assertSearch(indexingTestHelper -> {
            MatchAllQuery matchAllQuery = this.queries.matchAll();
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames(new String[]{"_all"});
            searchSearchRequest.setQuery((Query)matchAllQuery);
            searchSearchRequest.setSize(Integer.valueOf(0));
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)20L, (long)searchHits.getTotalHits());
            List searchHitsList = searchHits.getSearchHits();
            Assert.assertTrue((String)"Expected empty search hits", (boolean)searchHitsList.isEmpty());
        });
    }
}

