/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.json.JSONFactoryImpl;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.FieldArray;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.index.GetFieldMappingIndexRequest;
import com.liferay.portal.search.engine.adapter.index.GetFieldMappingIndexResponse;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.filter.ComplexQueryPartBuilderFactory;
import com.liferay.portal.search.internal.filter.ComplexQueryPartBuilderFactoryImpl;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.FieldValuesAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import com.liferay.portal.search.test.util.mappings.NestedDDMFieldArrayUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseNestedFieldsTestCase
extends BaseIndexingTestCase {
    private final ComplexQueryPartBuilderFactory _complexQueryPartBuilderFactory = new ComplexQueryPartBuilderFactoryImpl();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.addDocumentWithDDMFieldArray();
    }

    @Test
    public void testDDMFieldArrayDontMatchUnrelatedKeywordValue() throws Exception {
        this.assertSearch("ddm__text__41523__TextBox7nkv_en_US", "ddmFieldArray.ddmFieldValueKeyword", "true", false, 0);
    }

    @Test
    public void testDDMFieldArrayDontMatchUnrelatedTextValue() throws Exception {
        this.assertSearch("ddm__text__41523__TextBox7nkv_en_US", "ddmFieldArray.ddmFieldValueText", "bravo", false, 0);
    }

    @Test
    public void testDDMNestedFieldsDontMatchPartialKeyword() throws Exception {
        this.assertSearch("ddm__keyword__41523__Textggef_en_US", "ddmFieldArray.ddmFieldValueKeyword", "alpha", true, 0);
    }

    @Test
    public void testDDMNestedFieldsDontMatchUnrelatedKeywordValue() throws Exception {
        this.assertSearch("ddm__text__41523__TextBox7nkv_en_US", "ddmFieldArray.ddmFieldValueKeyword", "true", true, 0);
    }

    @Test
    public void testDDMNestedFieldsDontMatchUnrelatedTextValue() throws Exception {
        this.assertSearch("ddm__text__41523__TextBox7nkv_en_US", "ddmFieldArray.ddmFieldValueText", "bravo", true, 0);
    }

    @Test
    public void testDDMNestedFieldsDynamicMapping() throws Exception {
        JSONFactoryUtil jsonFactoryUtil = new JSONFactoryUtil();
        jsonFactoryUtil.setJSONFactory((JSONFactory)new JSONFactoryImpl());
        SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
        GetFieldMappingIndexRequest getFieldMappingIndexRequest = new GetFieldMappingIndexRequest(new String[]{String.valueOf(this.getCompanyId())}, this.getMappingName(), new String[]{"ddmFieldArray.ddmFieldValueText_en_US", "ddmFieldArray.ddmFieldValueKeyword"});
        GetFieldMappingIndexResponse getFieldMappingIndexResponse = (GetFieldMappingIndexResponse)searchEngineAdapter.execute((IndexRequest)getFieldMappingIndexRequest);
        Map fieldMappings = getFieldMappingIndexResponse.getFieldMappings();
        String fieldMapping = (String)fieldMappings.get(String.valueOf(this.getCompanyId()));
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fieldMapping);
        Assert.assertEquals((String)fieldMapping, (long)2L, (long)jsonObject.length());
        JSONObject jsonObject2 = jsonObject.getJSONObject("ddmFieldArray.ddmFieldValueText_en_US");
        JSONObject jsonObject3 = jsonObject2.getJSONObject("ddmFieldValueText_en_US");
        String analyzer = jsonObject3.getString("analyzer");
        Assert.assertEquals((String)fieldMapping, (Object)"english", (Object)analyzer);
    }

    @Test
    public void testDDMNestedFieldsMatchKeyword() throws Exception {
        this.assertSearch("ddm__keyword__41523__Textggef_en_US", "ddmFieldArray.ddmFieldValueKeyword", "alpha keyword", "alpha keyword");
    }

    @Test
    public void testDDMNestedFieldsMatchLocalizedText() throws Exception {
        this.assertSearch("ddm__text__41523__TextBoxnj7s_en_US", "ddmFieldArray.ddmFieldValueText_en_US", "charlie", "charlie text");
    }

    @Test
    public void testDDMNestedFieldsMatchMultipleValues() throws Exception {
        this.assertSearch("ddm__text__41523__TextBoxo9us_ja_JP", "ddmFieldArray.ddmFieldValueText_ja_JP", "\u4f5c\u6226\u5927\u6210\u529f", Arrays.asList("\u4f5c\u6226\u5927\u6210\u529f", "\u65b0\u898f\u4f5c\u6226"));
    }

    @Test
    public void testDDMNestedFieldsMatchText() throws Exception {
        this.assertSearch("ddm__text__41523__TextBox7nkv_en_US", "ddmFieldArray.ddmFieldValueText", "alpha", "alpha text");
    }

    protected void addDocumentWithDDMFieldArray() {
        FieldArray fieldArray = new FieldArray("ddmFieldArray");
        this.addNestedField("ddm__keyword__41523__Booleantua8_en_US_String_sortable", "ddmFieldValueKeyword", "true", fieldArray);
        this.addNestedField("ddm__keyword__41523__Textggef_en_US", "ddmFieldValueKeyword", "alpha keyword", fieldArray);
        this.addNestedField("ddm__keyword__41523__Textp47b_en_US", "ddmFieldValueKeyword", "bravo keyword", fieldArray);
        this.addNestedField("ddm__text__41523__TextBox7nkv_en_US", "ddmFieldValueText", "alpha text", fieldArray);
        this.addNestedField("ddm__text__41523__TextBox6yh3_en_US", "ddmFieldValueText", "bravo text", fieldArray);
        this.addNestedField("ddm__text__41523__TextBoxnj7s_en_US", "ddmFieldValueText_en_US", "charlie text", fieldArray);
        this.addNestedField("ddm__text__41523__TextBoxo9us_ja_JP", "ddmFieldValueText_ja_JP", new String[]{"\u4f5c\u6226\u5927\u6210\u529f", "\u65b0\u898f\u4f5c\u6226"}, fieldArray);
        this.addDocument(DocumentCreationHelpers.field((Field)fieldArray));
    }

    protected void addNestedField(String name, String valueFieldName, Object value, FieldArray fieldArray) {
        fieldArray.addField(NestedDDMFieldArrayUtil.createField(name, valueFieldName, value));
    }

    protected void addQuery(SearchRequestBuilder searchRequestBuilder, Query query) {
        searchRequestBuilder.addComplexQueryPart(this._complexQueryPartBuilderFactory.builder().query(query).build());
    }

    protected void assertOneResult(SearchResponse searchResponse) {
        FieldValuesAssert.assertFieldValue("groupId", this.getGroupId(), searchResponse);
    }

    protected void assertSearch(String fieldName, String valueFieldName, String value, boolean mappedAsNested, int expectedCount) {
        Query query = this.getQuery(this._buildQuery(fieldName, valueFieldName, value, mappedAsNested), mappedAsNested);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(this::fetchSourceIncludes);
            indexingTestHelper.defineRequest(searchRequestBuilder -> this.addQuery((SearchRequestBuilder)searchRequestBuilder, query));
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> DocumentsAssert.assertCount(indexingTestHelper.getRequestString(), hits.getDocs(), fieldName, expectedCount));
        });
    }

    protected void assertSearch(String fieldName, String valueFieldName, String value, Object expectedValue) {
        Query query = this.getQuery(this._buildQuery(fieldName, valueFieldName, value, true), true);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(this::fetchSourceIncludes);
            indexingTestHelper.defineRequest(searchRequestBuilder -> this.addQuery((SearchRequestBuilder)searchRequestBuilder, query));
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> {
                this.assertOneResult((SearchResponse)searchResponse);
                Document document = (Document)searchResponse.getDocumentsStream().findAny().get();
                List values = document.getValues("ddmFieldArray");
                Optional<Object> optional = NestedDDMFieldArrayUtil.getFieldValue(fieldName, values.stream());
                Assert.assertEquals((Object)expectedValue, optional.orElse(null));
            });
        });
    }

    protected void fetchSourceIncludes(SearchRequestBuilder searchRequestBuilder) {
        searchRequestBuilder.fetchSourceIncludes(new String[]{"ddmFieldArray.*", "groupId"});
    }

    protected abstract String getMappingName();

    protected Query getQuery(BooleanQuery booleanQuery, boolean mappedAsNested) {
        if (mappedAsNested) {
            return this.queries.nested("ddmFieldArray", (Query)booleanQuery);
        }
        return booleanQuery;
    }

    private BooleanQuery _buildQuery(String fieldName, String valueFieldName, String value, boolean mappedAsNested) {
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        if (mappedAsNested) {
            booleanQuery.addMustQueryClauses(new Query[]{this.queries.term("ddmFieldArray.ddmFieldName", (Object)fieldName)});
        } else {
            booleanQuery.addMustQueryClauses(new Query[]{this.queries.match("ddmFieldArray.ddmFieldName", (Object)fieldName)});
        }
        if (fieldName.startsWith("ddm__keyword")) {
            booleanQuery.addMustQueryClauses(new Query[]{this.queries.term(valueFieldName, (Object)value)});
        } else {
            booleanQuery.addMustQueryClauses(new Query[]{this.queries.match(valueFieldName, (Object)value)});
        }
        return booleanQuery;
    }
}

