/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.search.engine.SearchEngineInformation;
import com.liferay.portal.search.internal.analysis.DescriptionFieldQueryBuilder;
import com.liferay.portal.search.internal.analysis.TitleFieldQueryBuilder;
import com.liferay.portal.search.internal.query.FieldQueryFactoryImpl;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.field.FieldQueryFactory;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import com.liferay.portal.search.test.util.mappings.LiferayFieldQueryFactoryFixture;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;

public abstract class BaseLiferayFieldQueryFactoryTestCase
extends BaseIndexingTestCase {
    @Mock
    protected SearchEngineInformation searchEngineInformation;
    private static final String _DESCRIPTION_FIELD_QUERY_BUILDER_NAME = "DescriptionFieldQueryBuilder";
    private static final String _TITLE_FIELD_QUERY_BUILDER_NAME = "TitleFieldQueryBuilder";
    private String _fieldName;
    private String _fieldValue;
    private final LiferayFieldQueryFactoryFixture _liferayFieldQueryFactoryFixture = new LiferayFieldQueryFactoryFixture();

    @Test
    public void testContentField() {
        this.assertSearch("content", BaseLiferayFieldQueryFactoryTestCase.getEnglishBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getDescriptionStyleExpectations());
    }

    @Test
    public void testContentFieldEnglish() {
        this.assertSearch("content_en_US", BaseLiferayFieldQueryFactoryTestCase.getEnglishBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getDescriptionStyleExpectations());
    }

    @Test
    public void testContentFieldJapanese() {
        this.assertSearch("content_ja_JP", BaseLiferayFieldQueryFactoryTestCase.getJapaneseBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getDescriptionStyleExpectations());
    }

    @Test
    public void testContentFieldPortuguese() {
        this.assertSearch("content_pt_BR", BaseLiferayFieldQueryFactoryTestCase.getPortugueseBlueprint(), new Expectations(){
            {
                this.phrasePrefix = true;
                this.word1 = true;
                this.word2 = true;
                this.wordPrefix1 = true;
                this.wordPrefix2 = false;
            }
        });
    }

    @Test
    public void testDefaultQueryBuilder() {
        TestFieldQueryBuilderFactoryImpl testFieldQueryBuilderFactory = new TestFieldQueryBuilderFactoryImpl();
        TestFieldQueryBuilder testFieldQueryBuilder = testFieldQueryBuilderFactory.getTestFieldQueryBuilder(new TestDescriptionFieldQueryBuilder(), new TestTitleFieldQueryBuilder(), this.searchEngineInformation);
        String vendor = this.searchEngineInformation.getVendorString();
        String version = this.searchEngineInformation.getClientVersionString();
        String fieldQueryBuilderClassName = testFieldQueryBuilder.getClassName();
        if (vendor.equals("Elasticsearch") && version.equals("6") || vendor.equals("Solr")) {
            Assert.assertTrue((boolean)fieldQueryBuilderClassName.equals(_TITLE_FIELD_QUERY_BUILDER_NAME));
        } else {
            Assert.assertTrue((boolean)fieldQueryBuilderClassName.equals(_DESCRIPTION_FIELD_QUERY_BUILDER_NAME));
        }
    }

    @Test
    public void testDescriptionField() {
        this.assertSearch("description", BaseLiferayFieldQueryFactoryTestCase.getEnglishBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getDescriptionStyleExpectations());
    }

    @Test
    public void testDescriptionFieldEnglish() {
        this.assertSearch("description_en_US", BaseLiferayFieldQueryFactoryTestCase.getEnglishBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getDescriptionStyleExpectations());
    }

    @Test
    public void testDescriptionFieldJapanese() {
        this.assertSearch("description_ja_JP", BaseLiferayFieldQueryFactoryTestCase.getJapaneseBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getDescriptionStyleExpectations());
    }

    @Test
    public void testDescriptionFieldPortuguese() {
        this.assertSearch("description_pt_BR", BaseLiferayFieldQueryFactoryTestCase.getPortugueseBlueprint(), new Expectations(){
            {
                this.phrasePrefix = true;
                this.word1 = true;
                this.word2 = true;
                this.wordPrefix1 = true;
                this.wordPrefix2 = false;
            }
        });
    }

    @Test
    public void testKeywordMappedField() {
        this.assertSearch("properties", BaseLiferayFieldQueryFactoryTestCase.getEnglishBlueprint(), new Expectations(){
            {
                this.phrasePrefix = false;
                this.word1 = false;
                this.word2 = false;
                this.wordPrefix1 = false;
                this.wordPrefix2 = false;
            }
        });
    }

    @Test
    public void testKeywordMappedFieldEnglish() {
        this.assertSearch("properties_en_US", BaseLiferayFieldQueryFactoryTestCase.getEnglishBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getDescriptionStyleExpectations());
    }

    @Test
    public void testKeywordMappedFieldJapanese() {
        this.assertSearch("properties_ja_JP", BaseLiferayFieldQueryFactoryTestCase.getJapaneseBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getDescriptionStyleExpectations());
    }

    @Test
    public void testKeywordMappedFieldPortuguese() {
        this.assertSearch("properties_pt_BR", BaseLiferayFieldQueryFactoryTestCase.getPortugueseBlueprint(), new Expectations(){
            {
                this.phrasePrefix = true;
                this.word1 = true;
                this.word2 = true;
                this.wordPrefix1 = true;
                this.wordPrefix2 = false;
            }
        });
    }

    @Test
    public void testNameField() {
        this.assertSearch("name", BaseLiferayFieldQueryFactoryTestCase.getEnglishBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getTitleStyleExpectations());
    }

    @Test
    public void testNameFieldEnglish() {
        this.assertSearch("name_en_US", BaseLiferayFieldQueryFactoryTestCase.getEnglishBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getTitleStyleExpectations());
    }

    @Test
    public void testNameFieldJapanese() {
        this.assertSearch("name_ja_JP", BaseLiferayFieldQueryFactoryTestCase.getJapaneseBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getTitleStyleExpectations());
    }

    @Test
    public void testNameFieldPortuguese() {
        this.assertSearch("name_pt_BR", BaseLiferayFieldQueryFactoryTestCase.getPortugueseBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getTitleStyleExpectations());
    }

    @Test
    public void testTitleField() {
        this.assertSearch("title", BaseLiferayFieldQueryFactoryTestCase.getEnglishBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getTitleStyleExpectations());
    }

    @Test
    public void testTitleFieldEnglish() {
        this.assertSearch("title_en_US", BaseLiferayFieldQueryFactoryTestCase.getEnglishBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getTitleStyleExpectations());
    }

    @Test
    public void testTitleFieldJapanese() {
        this.assertSearch("title_ja_JP", BaseLiferayFieldQueryFactoryTestCase.getJapaneseBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getTitleStyleExpectations());
    }

    @Test
    public void testTitleFieldPortuguese() {
        this.assertSearch("title_pt_BR", BaseLiferayFieldQueryFactoryTestCase.getPortugueseBlueprint(), BaseLiferayFieldQueryFactoryTestCase.getTitleStyleExpectations());
    }

    protected static Expectations getDescriptionStyleExpectations() {
        return new Expectations(){
            {
                this.phrasePrefix = true;
                this.word1 = true;
                this.word2 = true;
                this.wordPrefix1 = false;
                this.wordPrefix2 = false;
            }
        };
    }

    protected static Blueprint getEnglishBlueprint() {
        return new Blueprint(){
            {
                this.phrase = "alpha bravo";
                this.phrasePrefix = "alpha brav";
                this.word1 = "alpha";
                this.word2 = "bravo";
                this.wordPrefix1 = "alph";
                this.wordPrefix2 = "brav";
            }
        };
    }

    protected static Blueprint getJapaneseBlueprint() {
        return new Blueprint(){
            {
                this.phrase = "\u65b0\u898f\u4f5c\u6210";
                this.phrasePrefix = "\u65b0\u898f\u4f5c";
                this.word1 = "\u65b0\u898f";
                this.word2 = "\u4f5c\u6210";
                this.wordPrefix1 = "\u65b0";
                this.wordPrefix2 = "\u4f5c";
            }
        };
    }

    protected static Blueprint getPortugueseBlueprint() {
        return new Blueprint(){
            {
                this.phrase = "Jo\u00e3o Ningu\u00e9m";
                this.phrasePrefix = "Jo\u00e3o Ningu\u00e9";
                this.word1 = "Jo\u00e3o";
                this.word2 = "Ningu\u00e9m";
                this.wordPrefix1 = "Jo\u00e3";
                this.wordPrefix2 = "Ningu\u00e9";
            }
        };
    }

    protected static Expectations getTitleStyleExpectations() {
        return new Expectations(){
            {
                this.phrasePrefix = true;
                this.word1 = true;
                this.word2 = true;
                this.wordPrefix1 = true;
                this.wordPrefix2 = true;
            }
        };
    }

    protected void assertSearch(String field, Blueprint blueprint, Expectations expectations) {
        this.setFieldName(field);
        this.setFieldValue(blueprint.phrase);
        this.indexOneDocument();
        this.assertSearch(blueprint.phrase, true);
        this.assertSearch(blueprint.word1, expectations.word1);
        this.assertSearch(blueprint.word2, expectations.word2);
        this.assertSearch(blueprint.wordPrefix1, expectations.wordPrefix1);
        this.assertSearch(blueprint.wordPrefix2, expectations.wordPrefix2);
        this.assertSearch(blueprint.phrasePrefix, expectations.phrasePrefix);
    }

    protected void assertSearch(String value, boolean hit) {
        FieldQueryFactory fieldQueryFactory = this._liferayFieldQueryFactoryFixture.getFieldQueryFactory();
        Query query = fieldQueryFactory.createQuery(this._fieldName, value, false, false);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.query(query));
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> DocumentsAssert.assertValues(searchResponse.getRequestString(), searchResponse.getDocumentsStream(), this._fieldName, "[" + this.getExpected(hit) + "]"));
        });
    }

    protected String getExpected(boolean hit) {
        if (hit) {
            return this._fieldValue;
        }
        return "";
    }

    protected void indexOneDocument() {
        this.addDocument(DocumentCreationHelpers.singleText(this._fieldName, this._fieldValue));
    }

    protected void setFieldName(String fieldName) {
        this._fieldName = fieldName;
    }

    protected void setFieldValue(String fieldValue) {
        this._fieldValue = fieldValue;
    }

    protected static class Expectations {
        protected boolean phrasePrefix;
        protected boolean word1;
        protected boolean word2;
        protected boolean wordPrefix1;
        protected boolean wordPrefix2;

        protected Expectations() {
        }
    }

    protected static class Blueprint {
        protected String phrase;
        protected String phrasePrefix;
        protected String word1;
        protected String word2;
        protected String wordPrefix1;
        protected String wordPrefix2;

        protected Blueprint() {
        }
    }

    public class TestTitleFieldQueryBuilder
    extends TitleFieldQueryBuilder
    implements TestFieldQueryBuilder {
        @Override
        public String getClassName() {
            return BaseLiferayFieldQueryFactoryTestCase._TITLE_FIELD_QUERY_BUILDER_NAME;
        }
    }

    public class TestFieldQueryBuilderFactoryImpl
    extends FieldQueryFactoryImpl
    implements TestFieldQueryBuilderFactory {
        @Override
        public TestFieldQueryBuilder getTestFieldQueryBuilder(DescriptionFieldQueryBuilder descriptionFieldQueryBuilder, TitleFieldQueryBuilder titleFieldQueryBuilder, SearchEngineInformation searchEngineInformation) {
            this.setDescriptionFieldQueryBuilder(descriptionFieldQueryBuilder);
            this.setTitleFieldQueryBuilder(titleFieldQueryBuilder);
            this.setSearchEngineInformation(searchEngineInformation);
            return (TestFieldQueryBuilder)this.getDefaultQueryBuilder();
        }
    }

    public static interface TestFieldQueryBuilderFactory {
        public TestFieldQueryBuilder getTestFieldQueryBuilder(DescriptionFieldQueryBuilder var1, TitleFieldQueryBuilder var2, SearchEngineInformation var3);
    }

    public static interface TestFieldQueryBuilder {
        public String getClassName();
    }

    public class TestDescriptionFieldQueryBuilder
    extends DescriptionFieldQueryBuilder
    implements TestFieldQueryBuilder {
        @Override
        public String getClassName() {
            return BaseLiferayFieldQueryFactoryTestCase._DESCRIPTION_FIELD_QUERY_BUILDER_NAME;
        }
    }
}

