/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.highlight;

import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.highlight.Highlight;
import com.liferay.portal.search.highlight.HighlightField;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.StringQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseHighlighterTestCase
extends BaseIndexingTestCase {
    @Test
    public void testHighlight() {
        String fieldName = "title";
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(fieldName, value), Arrays.asList("alpha", "alpha beta", "alpha beta alpha", "alpha beta gamma alpha eta theta alpha zeta eta alpha iota", "alpha beta gamma delta epsilon zeta eta theta iota alpha"));
        StringQuery query = this.queries.string(fieldName.concat(":alpha"));
        Highlight highlight = this.highlights.builder().addFieldConfig(this.highlights.fieldConfigBuilder().field(fieldName).build()).fragmentSize(Integer.valueOf(20)).postTags(new String[]{"[/H]"}).preTags(new String[]{"[H]"}).build();
        this.assertSearch(fieldName, (Query)query, highlight, Arrays.asList("[H]alpha[/H]", "[H]alpha[/H] beta", "[H]alpha[/H] beta [H]alpha[/H]", "[H]alpha[/H] beta gamma [H]alpha[/H]", "[H]alpha[/H] beta gamma delta", "eta [H]alpha[/H] iota", "eta theta [H]alpha[/H] zeta", "zeta eta theta iota [H]alpha[/H]"));
    }

    protected void assertSearch(String fieldName, Query query, Highlight highlight, List<String> expectedValues) {
        this.assertSearch(indexingTestHelper -> {
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames(new String[]{"_all"});
            searchSearchRequest.setQuery(query);
            searchSearchRequest.setSize(Integer.valueOf(30));
            searchSearchRequest.setHighlight(highlight);
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            List searchHitsList = searchHits.getSearchHits();
            ArrayList actualValues = new ArrayList();
            Stream stream = searchHitsList.stream();
            stream.map(searchHit -> this.getFragments(fieldName, (SearchHit)searchHit)).forEach(actualValues::addAll);
            Collections.sort(actualValues);
            Collections.sort(expectedValues);
            Assert.assertEquals((String)("Highlighted texts ->" + actualValues), (Object)expectedValues.toString(), (Object)((Object)actualValues).toString());
        });
    }

    protected List<String> getFragments(String fieldName, SearchHit searchHit) {
        Map highlightFields = searchHit.getHighlightFieldsMap();
        HighlightField highlightField = (HighlightField)highlightFields.get(fieldName);
        return highlightField.getFragments();
    }
}

