/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.expando;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.util.ExpandoBridgeFactory;
import com.liferay.expando.kernel.util.ExpandoBridgeIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.query.FieldQueryFactory;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.search.analysis.FieldQueryBuilderFactory;
import com.liferay.portal.search.internal.analysis.DescriptionFieldQueryBuilder;
import com.liferay.portal.search.internal.analysis.SimpleKeywordTokenizer;
import com.liferay.portal.search.internal.analysis.SubstringFieldQueryBuilder;
import com.liferay.portal.search.internal.expando.ExpandoFieldQueryBuilderFactory;
import com.liferay.portal.search.internal.expando.ExpandoQueryContributorHelper;
import com.liferay.portal.search.internal.query.FieldQueryFactoryImpl;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelper;
import com.liferay.registry.BasicRegistryImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public abstract class BaseExpandoTestCase
extends BaseIndexingTestCase {
    private static final String _ATTRIBUTE_KEYWORD = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
    private static final String _ATTRIBUTE_TEXT = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
    private static final String _CLASS_NAME_KEYWORD = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
    private static final String _CLASS_NAME_TEXT = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
    private static final String _FIELD_KEYWORD = "expando__keyword__custom_fields__testColumnName";
    private static final String _FIELD_TEXT = "expando__custom_fields__testColumnName";

    @BeforeClass
    public static void setUpClassBaseExpandoTestCase() {
        BasicRegistryImpl registry = new BasicRegistryImpl();
        registry.registerService(FieldQueryFactory.class, (Object)BaseExpandoTestCase.createFieldQueryFactory((FieldQueryBuilderFactory)BaseExpandoTestCase.createExpandoFieldQueryBuilderFactory()));
        RegistryUtil.setRegistry((Registry)registry);
    }

    @AfterClass
    public static void tearDownClassBaseExpandoTestCase() {
        RegistryUtil.setRegistry(null);
    }

    @Test
    public void testMultipleClassNames() throws Exception {
        List<String> duplicates = Arrays.asList("alpha", "alpha", "alpha bravo", "charlie", "delta");
        this.addDocuments(this::addKeyword, duplicates);
        this.addDocuments(this::addKeyword, Arrays.asList("keyword"));
        this.addDocuments(this::addText, duplicates);
        this.addDocuments(this::addText, Arrays.asList("text"));
        this.assertSearch("alpha", 6);
        this.assertSearch("bravo", 2);
        this.assertSearch("alpha bravo", 6);
        this.assertSearch("rlie", 1);
        this.assertSearch("echo", 0);
        this.assertSearch("keyword", 1);
        this.assertSearch("text", 1);
    }

    protected static DescriptionFieldQueryBuilder createDescriptionFieldQueryBuilder() {
        return new DescriptionFieldQueryBuilder(){
            {
                this.keywordTokenizer = new SimpleKeywordTokenizer();
            }
        };
    }

    protected static ExpandoFieldQueryBuilderFactory createExpandoFieldQueryBuilderFactory() {
        return new ExpandoFieldQueryBuilderFactory(){
            {
                this.substringQueryBuilder = new SubstringFieldQueryBuilder(){
                    {
                        this.keywordTokenizer = new SimpleKeywordTokenizer();
                    }
                };
            }
        };
    }

    protected static FieldQueryFactoryImpl createFieldQueryFactory(final FieldQueryBuilderFactory fieldQueryBuilderFactory) {
        return new FieldQueryFactoryImpl(){
            {
                this.addFieldQueryBuilderFactory(fieldQueryBuilderFactory);
                this.setDescriptionFieldQueryBuilder(BaseExpandoTestCase.createDescriptionFieldQueryBuilder());
            }
        };
    }

    protected DocumentCreationHelper addKeyword(String value) {
        return document -> {
            document.addKeyword("status", _FIELD_KEYWORD + value);
            document.addKeyword(_FIELD_KEYWORD, value);
        };
    }

    protected DocumentCreationHelper addText(String value) {
        return document -> {
            document.addKeyword("status", _FIELD_TEXT + value);
            document.addText(_FIELD_TEXT, value);
        };
    }

    protected void assertSearch(String keywords, int expectedCount) throws Exception {
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, () -> this.doAssertSearch(keywords, expectedCount));
    }

    protected ExpandoBridge createExpandoBridge(String attributeName, int indexType) {
        ExpandoBridge expandoBridge = (ExpandoBridge)Mockito.mock(ExpandoBridge.class);
        ((ExpandoBridge)Mockito.doReturn(Collections.enumeration(Collections.singletonList(attributeName))).when((Object)expandoBridge)).getAttributeNames();
        ((ExpandoBridge)Mockito.doReturn((Object)this.createUnicodeProperties(indexType)).when((Object)expandoBridge)).getAttributeProperties(Mockito.anyString());
        return expandoBridge;
    }

    protected ExpandoBridgeFactory createExpandoBridgeFactory() {
        ExpandoBridgeFactory expandoBridgeFactory = (ExpandoBridgeFactory)Mockito.mock(ExpandoBridgeFactory.class);
        ((ExpandoBridgeFactory)Mockito.doReturn((Object)this.createExpandoBridge(_ATTRIBUTE_KEYWORD, 2)).when((Object)expandoBridgeFactory)).getExpandoBridge(Mockito.anyLong(), (String)Matchers.eq((Object)_CLASS_NAME_KEYWORD));
        ((ExpandoBridgeFactory)Mockito.doReturn((Object)this.createExpandoBridge(_ATTRIBUTE_TEXT, 1)).when((Object)expandoBridgeFactory)).getExpandoBridge(Mockito.anyLong(), (String)Matchers.eq((Object)_CLASS_NAME_TEXT));
        return expandoBridgeFactory;
    }

    protected ExpandoBridgeIndexer createExpandoBridgeIndexer() {
        ExpandoBridgeIndexer expandoBridgeIndexer = (ExpandoBridgeIndexer)Mockito.mock(ExpandoBridgeIndexer.class);
        ((ExpandoBridgeIndexer)Mockito.doReturn((Object)_FIELD_KEYWORD).when((Object)expandoBridgeIndexer)).encodeFieldName(Mockito.anyString(), Matchers.eq((int)2));
        ((ExpandoBridgeIndexer)Mockito.doReturn((Object)_FIELD_TEXT).when((Object)expandoBridgeIndexer)).encodeFieldName(Mockito.anyString(), Matchers.eq((int)1));
        return expandoBridgeIndexer;
    }

    protected ExpandoColumn createExpandoColumn(int indexType) {
        ExpandoColumn expandoColumn = (ExpandoColumn)Mockito.mock(ExpandoColumn.class);
        ((ExpandoColumn)Mockito.doReturn((Object)this.createUnicodeProperties(indexType)).when((Object)expandoColumn)).getTypeSettingsProperties();
        ((ExpandoColumn)Mockito.doReturn((Object)15).when((Object)expandoColumn)).getType();
        return expandoColumn;
    }

    protected ExpandoColumnLocalService createExpandoColumnLocalService() {
        ExpandoColumnLocalService expandoColumnLocalService = (ExpandoColumnLocalService)Mockito.mock(ExpandoColumnLocalService.class);
        ((ExpandoColumnLocalService)Mockito.doReturn((Object)this.createExpandoColumn(2)).when((Object)expandoColumnLocalService)).getDefaultTableColumn(Mockito.anyLong(), Mockito.anyString(), (String)Mockito.eq((Object)_ATTRIBUTE_KEYWORD));
        ((ExpandoColumnLocalService)Mockito.doReturn((Object)this.createExpandoColumn(1)).when((Object)expandoColumnLocalService)).getDefaultTableColumn(Mockito.anyLong(), Mockito.anyString(), (String)Mockito.eq((Object)_ATTRIBUTE_TEXT));
        return expandoColumnLocalService;
    }

    protected ExpandoQueryContributorHelper createExpandoQueryContributorHelper() {
        return new ExpandoQueryContributorHelper(this.createExpandoBridgeFactory(), this.createExpandoBridgeIndexer(), this.createExpandoColumnLocalService(), null);
    }

    protected UnicodeProperties createUnicodeProperties(int indexType) {
        UnicodeProperties unicodeProperties = (UnicodeProperties)Mockito.mock(UnicodeProperties.class);
        ((UnicodeProperties)Mockito.doReturn((Object)String.valueOf(indexType)).when((Object)unicodeProperties)).getProperty("index-type");
        return unicodeProperties;
    }

    protected Void doAssertSearch(String keywords, int expectedCount) throws Exception {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        SearchContext searchContext = this.createSearchContext();
        ExpandoQueryContributorHelper expandoQueryContributorHelper = this.createExpandoQueryContributorHelper();
        expandoQueryContributorHelper.setAndSearch(searchContext.isAndSearch());
        expandoQueryContributorHelper.setBooleanQuery((BooleanQuery)booleanQuery);
        expandoQueryContributorHelper.setClassNamesStream(Stream.of(_CLASS_NAME_KEYWORD, _CLASS_NAME_TEXT));
        expandoQueryContributorHelper.setCompanyId(searchContext.getCompanyId());
        expandoQueryContributorHelper.setKeywords(keywords);
        expandoQueryContributorHelper.setLocale(searchContext.getLocale());
        expandoQueryContributorHelper.contribute();
        Hits hits = this.search(searchContext, (Query)booleanQuery);
        DocumentsAssert.assertCount((String)((Object)searchContext.getAttribute("queryString")), hits.getDocs(), "status", expectedCount);
        return null;
    }
}

