/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.StatsBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.StatsBucketPipelineAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseStatsBucketPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testStatsBucketPipeline() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        StatsBucketPipelineAggregation statsBucketPipelineAggregation = this.aggregations.statsBucket("stats_bucket", "histogram>sum");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation((Aggregation)this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation((PipelineAggregation)statsBucketPipelineAggregation);
            });
            indexingTestHelper.search();
            StatsBucketPipelineAggregationResult statsBucketPipelineAggregationResult = (StatsBucketPipelineAggregationResult)indexingTestHelper.getAggregationResult((PipelineAggregation)statsBucketPipelineAggregation);
            Assert.assertEquals((String)"Avg summged in buckets", (double)42.0, (double)statsBucketPipelineAggregationResult.getAvg(), (double)0.0);
            Assert.assertEquals((String)"Total count in buckets", (float)5.0f, (float)statsBucketPipelineAggregationResult.getCount(), (float)0.0f);
            Assert.assertEquals((String)"Max summed priority in buckets", (double)85.0, (double)statsBucketPipelineAggregationResult.getMax(), (double)0.0);
            Assert.assertEquals((String)"Min summed priority in buckets", (double)10.0, (double)statsBucketPipelineAggregationResult.getMin(), (double)0.0);
            Assert.assertEquals((String)"Summed priority in buckets", (double)210.0, (double)statsBucketPipelineAggregationResult.getSum(), (double)0.0);
        });
    }
}

