/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.BucketAggregationResult;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.MovingFunctionPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MovingFunctionPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.script.Script;
import com.liferay.portal.search.test.util.aggregation.AggregationAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Map;
import org.junit.Test;

public abstract class BaseMovingFunctionPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testMovingFunction() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        HistogramAggregation histogramAggregation = this.aggregationFixture.getDefaultHistogramAggregation();
        Script script = this.scripts.script("MovingFunctions.unweightedAvg(values)");
        MovingFunctionPipelineAggregation movingFunctionPipelineAggregation = this.aggregations.movingFunction("moving_fn", script, "sum", 5);
        histogramAggregation.addPipelineAggregation((PipelineAggregation)movingFunctionPipelineAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)histogramAggregation));
            indexingTestHelper.search();
            HistogramAggregationResult histogramAggregationResult = (HistogramAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)histogramAggregation);
            AggregationAssert.assertBuckets("[0.0=4, 5.0=5, 10.0=5, 15.0=5, 20.0=1]", (BucketAggregationResult)histogramAggregationResult);
            AggregationAssert.assertBucketValues("NaN, 10.0, 22.5, 35.0, 47.5", this::getMovingFunctionValue, (BucketAggregationResult)histogramAggregationResult);
        });
    }

    protected double getMovingFunctionValue(Bucket bucket) {
        Map childrenAggregationResults = bucket.getChildrenAggregationResults();
        MovingFunctionPipelineAggregationResult movingFunctionPipelineAggregationResult = (MovingFunctionPipelineAggregationResult)childrenAggregationResults.get("moving_fn");
        return movingFunctionPipelineAggregationResult.getValue();
    }
}

