/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class IndexedFieldsFixture {
    private final Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
    private final DocumentBuilderFactory _documentBuilderFactory;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final SearchEngineHelper _searchEngineHelper;

    public IndexedFieldsFixture(ResourcePermissionLocalService resourcePermissionLocalService, SearchEngineHelper searchEngineHelper) {
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._searchEngineHelper = searchEngineHelper;
        this._documentBuilderFactory = null;
    }

    public IndexedFieldsFixture(ResourcePermissionLocalService resourcePermissionLocalService, SearchEngineHelper searchEngineHelper, DocumentBuilderFactory documentBuilderFactory) {
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._searchEngineHelper = searchEngineHelper;
        this._documentBuilderFactory = documentBuilderFactory;
    }

    public void populateDate(String field, Date value, Map<String, String> map) {
        map.put(field, this._dateFormat.format(value));
        map.put(field.concat("_sortable"), String.valueOf(value.getTime()));
    }

    public void populateExpirationDateWithForever(Map<String, String> map) {
        this.populateDate("expirationDate", new Date(Long.MAX_VALUE), map);
        if (this._isSearchEngineElasticsearch()) {
            map.put("expirationDate", "99950812133000");
        }
    }

    public void populatePriority(String priority, Map<String, String> map) {
        this.populatePriority(priority, map, false);
    }

    public void populatePriority(String priority, Map<String, String> map, boolean sourceFilteringEnabled) {
        map.put("priority", priority);
        if (sourceFilteringEnabled || this._isSearchEngineSolr()) {
            map.put("priority".concat("_sortable"), priority);
        }
    }

    public void populateRoleIdFields(long companyId, String className, long classPK, long groupId, String viewActionId, Map<String, String> map) throws Exception {
        if (Validator.isNull((String)viewActionId)) {
            viewActionId = "VIEW";
        }
        List roles = this._resourcePermissionLocalService.getRoles(companyId, className, 4, String.valueOf(classPK), viewActionId);
        ArrayList<String> groupRoleIds = new ArrayList<String>();
        ArrayList<String> roleIds = new ArrayList<String>();
        for (Role role : roles) {
            if (role.getType() == 3 || role.getType() == 2) {
                groupRoleIds.add(groupId + "-" + role.getRoleId());
                continue;
            }
            roleIds.add(String.valueOf(role.getRoleId()));
        }
        this.populateRoleIds("groupRoleId", groupRoleIds, map);
        this.populateRoleIds("roleId", roleIds, map);
    }

    public void populateUID(String modelClassName, long id, Map<String, String> map) {
        map.put("uid", modelClassName + "_PORTLET_" + id);
    }

    public void populateViewCount(Class<?> clazz, long classPK, Map<String, String> map) throws Exception {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(clazz);
        AssetEntry assetEntry = assetRendererFactory.getAssetEntry(clazz.getName(), classPK);
        map.put("viewCount", String.valueOf(assetEntry.getViewCount()));
        map.put("viewCount_sortable", String.valueOf(assetEntry.getViewCount()));
    }

    public void postProcessDocument(Document document) {
        if (this._isSearchEngineSolr()) {
            document.remove("score");
        }
    }

    public com.liferay.portal.search.document.Document postProcessDocument(com.liferay.portal.search.document.Document document) {
        if (this._isSearchEngineSolr()) {
            DocumentBuilder documentBuilder = this._documentBuilderFactory.builder(document);
            documentBuilder.unsetValue("score");
            return documentBuilder.build();
        }
        return document;
    }

    protected void populateRoleIds(String field, List<String> values, Map<String, String> map) {
        if (values.size() == 1) {
            map.put(field, values.get(0));
        } else if (values.size() > 1) {
            map.put(field, values.toString());
        }
    }

    private boolean _isSearchEngine(String vendor) {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine(this._searchEngineHelper.getDefaultSearchEngineId());
        return vendor.equals(searchEngine.getVendor());
    }

    private boolean _isSearchEngineElasticsearch() {
        return this._isSearchEngine("Elasticsearch");
    }

    private boolean _isSearchEngineSolr() {
        return this._isSearchEngine("Solr");
    }
}

