/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.test.util.AssertUtils;
import com.liferay.portal.search.test.util.SearchStreamUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldValuesAssert {
    public static void assertFieldValue(String fieldName, Object fieldValue, SearchResponse searchResponse) {
        FieldValuesAssert.assertFieldValues(Collections.singletonMap(fieldName, fieldValue), Predicate.isEqual(fieldName), searchResponse);
    }

    public static void assertFieldValues(Map<String, ?> expected, Document document, String message) {
        AssertUtils.assertEquals(message, FieldValuesAssert._toStringValuesMap(expected), FieldValuesAssert._toLegacyFieldValuesMap(document));
    }

    public static void assertFieldValues(Map<String, ?> expected, Predicate<String> keysPredicate, SearchResponse searchResponse) {
        Map<String, String> expectedFieldValuesMap = FieldValuesAssert._toStringValuesMap(expected);
        Stream stream = searchResponse.getDocumentsStream();
        List documents = stream.collect(Collectors.toList());
        if (documents.size() == 1) {
            Map<String, String> actualFieldValuesMap = FieldValuesAssert._toFieldValuesMap((com.liferay.portal.search.document.Document)documents.get(0));
            Map<String, String> filteredFieldValuesMap = FieldValuesAssert._filterOnKey(actualFieldValuesMap, keysPredicate);
            AssertUtils.assertEquals(() -> StringBundler.concat((Object[])new Object[]{searchResponse.getRequestString(), "->", actualFieldValuesMap, "->", filteredFieldValuesMap}), expectedFieldValuesMap, filteredFieldValuesMap);
        } else {
            AssertUtils.assertEquals(() -> StringBundler.concat((Object[])new Object[]{searchResponse.getRequestString(), "->", documents}), expectedFieldValuesMap, documents);
        }
    }

    public static void assertFieldValues(Map<String, ?> expected, SearchResponse searchResponse) {
        FieldValuesAssert.assertFieldValues(expected, null, searchResponse);
    }

    public static void assertFieldValues(Map<String, ?> expected, String prefix, Document document, String message) {
        AssertUtils.assertEquals(message, FieldValuesAssert._toStringValuesMap(expected), FieldValuesAssert._filterOnKey(FieldValuesAssert._toLegacyFieldValuesMap(document), name -> name.startsWith(prefix)));
    }

    public static void assertFieldValues(String message, com.liferay.portal.search.document.Document document, Map<?, ?> expected) {
        AssertUtils.assertEquals(message, expected, FieldValuesAssert._toFieldValuesMap(document));
    }

    @Deprecated
    public static void assertFieldValues(String message, com.liferay.portal.search.document.Document document, Predicate<String> keysPredicate, Map<?, ?> expected) {
        AssertUtils.assertEquals(message, expected, FieldValuesAssert._filterOnKey(FieldValuesAssert._toFieldValuesMap(document), keysPredicate));
    }

    private static void _addFields(Map<String, Field> map, String parentKey, Collection<Field> fields) {
        for (Field field : fields) {
            String key = field.getName();
            if (Validator.isNull((String)key)) {
                FieldValuesAssert._addFields(map, parentKey, field.getFields());
                continue;
            }
            if (parentKey != null) {
                key = StringBundler.concat((String[])new String[]{parentKey, ".", key});
            }
            if (field.getValues() != null) {
                map.put(key, field);
            }
            FieldValuesAssert._addFields(map, key, field.getFields());
        }
    }

    private static Map<String, String> _filterOnKey(Map<String, String> map, Predicate<String> predicate) {
        if (predicate == null) {
            return map;
        }
        Stream<Map.Entry<String, String>> stream = SearchStreamUtil.stream(map.entrySet());
        return stream.filter(entry -> predicate.test((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static <E> List<E> _sort(List<E> list) {
        ArrayList<E> sortedList = new ArrayList<E>(list);
        try {
            Collections.sort(sortedList, null);
        }
        catch (ClassCastException | NullPointerException exception) {
            return list;
        }
        return sortedList;
    }

    private static String _toFieldString(com.liferay.portal.search.document.Field field) {
        return FieldValuesAssert._toListString(field.getValues());
    }

    private static Map<String, String> _toFieldValuesMap(com.liferay.portal.search.document.Document document) {
        return FieldValuesAssert._toStringValuesMap(document.getFields(), FieldValuesAssert::_toFieldString);
    }

    private static String _toLegacyFieldString(Field field) {
        return FieldValuesAssert._toListString(Arrays.asList(field.getValues()));
    }

    private static Map<String, String> _toLegacyFieldValuesMap(Document document) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        Map documentFields = document.getFields();
        FieldValuesAssert._addFields(map, null, documentFields.values());
        return FieldValuesAssert._toStringValuesMap(map, FieldValuesAssert::_toLegacyFieldString);
    }

    private static String _toListString(List<?> values) {
        if (values == null) {
            return null;
        }
        if (values.size() == 1) {
            return String.valueOf(values.get(0));
        }
        if (!values.isEmpty()) {
            return String.valueOf(FieldValuesAssert._sort(values));
        }
        return "[]";
    }

    private static String _toObjectString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return FieldValuesAssert._toListString((List)value);
        }
        return String.valueOf(value);
    }

    private static Map<String, String> _toStringValuesMap(Map<String, ?> map) {
        return FieldValuesAssert._toStringValuesMap(map, FieldValuesAssert::_toObjectString);
    }

    private static <T> Map<String, String> _toStringValuesMap(Map<String, T> map, Function<T, String> function) {
        Stream<Map.Entry<String, Map.Entry>> stream = SearchStreamUtil.stream(map.entrySet());
        return stream.collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)function.apply(entry.getValue())));
    }
}

