/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.sort;

import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.search.internal.SortFactoryImpl;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelper;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Date;
import java.util.function.Function;
import org.junit.Test;

public abstract class BaseSortTestCase
extends BaseIndexingTestCase {
    @Test
    public void testDefaultSorts() throws Exception {
        double[] values = new double[]{1.0, 2.0, 3.0};
        this.addDocuments((Double value) -> document -> {
            document.addDate("modified", new Date(value.longValue()));
            document.addNumber("priority", value);
        }, values);
        SortFactoryImpl sortFactory = new SortFactoryImpl();
        this.assertOrder(sortFactory.getDefaultSorts(), "priority", "[3.0, 2.0, 1.0]");
    }

    @Test
    public void testPriorityField() throws Exception {
        this.testDoubleField("priority");
    }

    @Test
    public void testPriorityFieldSortable() throws Exception {
        this.testDoubleFieldSortable("priority");
    }

    protected void addDocuments(Function<Double, DocumentCreationHelper> function, double ... values) throws Exception {
        for (double value : values) {
            this.addDocument(function.apply(value));
        }
    }

    protected void assertOrder(Sort[] sorts, String fieldName, String expected) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> searchContext.setSorts(sorts));
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> DocumentsAssert.assertValues(indexingTestHelper.getRequestString(), hits.getDocs(), fieldName, expected));
        });
    }

    protected void assertOrder(String fieldName, int sortType, String expected) throws Exception {
        this.assertOrder(new Sort[]{new Sort(fieldName, sortType, false)}, fieldName, expected);
    }

    protected void testDoubleField(String fieldName) throws Exception {
        this.testDoubleField(fieldName, value -> DocumentCreationHelpers.singleNumber(fieldName, value));
    }

    protected void testDoubleField(String fieldName, Function<Double, DocumentCreationHelper> function) throws Exception {
        double[] values = new double[]{10.0, 1.0, 40.0, 5.3};
        this.addDocuments(function, values);
        this.assertOrder(fieldName, 7, "[1.0, 5.3, 10.0, 40.0]");
    }

    protected void testDoubleFieldSortable(String fieldName) throws Exception {
        this.testDoubleField(fieldName, value -> DocumentCreationHelpers.singleNumberSortable(fieldName, value));
    }
}

