/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query.string;

import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseQueryStringTestCase
extends BaseIndexingTestCase {
    @Test
    public void testPresentAfterSearch() throws Exception {
        this.doTestPresentAfter(BaseIndexingTestCase.IndexingTestHelper::search);
    }

    @Test
    public void testPresentAfterSearchCount() throws Exception {
        this.doTestPresentAfter(BaseIndexingTestCase.IndexingTestHelper::searchCount);
    }

    @Test
    public void testResponseBlankByDefaultButNeverNull() throws Exception {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> Assert.assertEquals((Object)"", (Object)searchResponse.getResponseString()));
        });
    }

    protected void doTestPresentAfter(Consumer<BaseIndexingTestCase.IndexingTestHelper> consumer) {
        this.addDocument(document -> {});
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addSelectedFieldNames(new String[]{"_source"}).includeResponseString(true));
            consumer.accept((BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper);
            indexingTestHelper.verifyContext(searchContext -> Assert.assertThat((Object)((String)((Object)searchContext.getAttribute("queryString"))), (Matcher)CoreMatchers.containsString((String)this.getExpectedPartOfRequestString())));
            indexingTestHelper.verifyResponse(searchResponse -> {
                Assert.assertThat((Object)searchResponse.getRequestString(), (Matcher)CoreMatchers.containsString((String)this.getExpectedPartOfRequestString()));
                Assert.assertThat((Object)searchResponse.getResponseString(), (Matcher)CoreMatchers.containsString((String)this.getExpectedPartOfResponseString()));
            });
        });
    }

    protected String getExpectedPartOfRequestString() {
        return "entryClassName";
    }

    protected abstract String getExpectedPartOfResponseString();
}

