/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermsSetQuery;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;

public abstract class BaseTermsSetQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testTermsSetQueryWithField() {
        this.index(1, "alpha");
        this.index(2, "alpha", "bravo");
        this.index(3, "alpha", "bravo", "charlie");
        this.assertTermsSetWithField(Arrays.asList("alpha"), "[alpha]");
        this.assertTermsSetWithField(Arrays.asList("alpha", "bravo"), "[[alpha, bravo], alpha]");
        this.assertTermsSetWithField(Arrays.asList("alpha", "bravo", "charlie"), "[[alpha, bravo, charlie], [alpha, bravo], alpha]");
        this.assertTermsSetWithField(Arrays.asList("bravo"), "[]");
        this.assertTermsSetWithField(Arrays.asList("bravo", "charlie"), "[]");
    }

    @Test
    public void testTermsSetQueryWithScript() {
        this.index(1, "alpha");
        this.index(2, "alpha", "bravo");
        this.index(3, "alpha", "bravo", "charlie");
        String source = "Math.min(params.num_terms, doc['priority'].value)";
        this.assertTermsSetWithScript(Arrays.asList("alpha"), source, "[[alpha, bravo, charlie], [alpha, bravo], alpha]");
        this.assertTermsSetWithScript(Arrays.asList("alpha", "bravo"), source, "[[alpha, bravo, charlie], [alpha, bravo], alpha]");
        this.assertTermsSetWithScript(Arrays.asList("alpha", "bravo", "charlie"), source, "[[alpha, bravo, charlie], [alpha, bravo], alpha]");
        this.assertTermsSetWithScript(Arrays.asList("bravo"), source, "[[alpha, bravo, charlie], [alpha, bravo]]");
        this.assertTermsSetWithScript(Arrays.asList("bravo", "charlie"), source, "[[alpha, bravo, charlie]]");
    }

    protected void assertTermsSet(TermsSetQuery termsSetQuery, String expected) {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.query((Query)termsSetQuery));
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> DocumentsAssert.assertValuesIgnoreRelevance(searchResponse.getRequestString(), searchResponse.getDocumentsStream(), "userName", expected));
        });
    }

    protected void assertTermsSetWithField(List<Object> terms, String expected) {
        TermsSetQuery termsSetQuery = this.queries.termsSet("userName", terms);
        termsSetQuery.setMinimumShouldMatchField("priority");
        this.assertTermsSet(termsSetQuery, expected);
    }

    protected void assertTermsSetWithScript(List<Object> terms, String source, String expected) {
        TermsSetQuery termsSetQuery = this.queries.termsSet("userName", terms);
        termsSetQuery.setMinimumShouldMatchScript(this.scripts.script(source));
        this.assertTermsSet(termsSetQuery, expected);
    }

    protected void index(int priority, String ... userNames) {
        this.addDocument(document -> {
            document.addKeyword("userName", userNames);
            document.addNumber("priority", priority);
        });
    }
}

