/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseTermQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testTermQuery() {
        this.addDocument(document -> {
            document.addKeyword("uid", 1);
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("uid", 2);
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("uid", 3);
            document.addKeyword("userName", "SomeUser3");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("uid", 4);
            document.addKeyword("userName", "SomeUser4");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("uid", 5);
            document.addKeyword("userName", "SomeUser5");
            document.addNumber("priority", 1);
        });
        this.assertSearch(indexingTestHelper -> {
            TermQuery termQuery = this.queries.term("userName", (Object)"SomeUser5");
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames(new String[]{"_all"});
            searchSearchRequest.setQuery((Query)termQuery);
            searchSearchRequest.setSize(Integer.valueOf(30));
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)1L, (long)searchHits.getTotalHits());
            List searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals((String)"Retrieved hits", (long)1L, (long)searchHitsList.size());
            SearchHit searchHit = (SearchHit)searchHitsList.get(0);
            Document document = searchHit.getDocument();
            Assert.assertEquals((Object)"SomeUser5", (Object)document.getString("userName"));
        });
    }
}

