/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.StringQuery;
import com.liferay.portal.search.query.TermQuery;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseStringQueryTestCase
extends BaseIndexingTestCase {
    private static final String _FIELD_NAME = "title";

    @Test
    public void testBooleanOperatorAnd() throws Exception {
        this.addDocuments("java eclipse", "java liferay", "java liferay eclipse");
        this.assertSearch("java AND eclipse", Arrays.asList("java eclipse", "java liferay eclipse"));
        this.assertSearch("eclipse AND liferay", Arrays.asList("java liferay eclipse"));
    }

    @Test
    public void testBooleanOperatorAndWithNot() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("alpha AND NOT bravo", Arrays.asList("alpha charlie"));
    }

    @Test
    public void testBooleanOperatorNot() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("NOT alpha", Arrays.asList("charlie delta"));
        this.assertSearch("NOT bravo", Arrays.asList("alpha charlie", "charlie delta"));
    }

    @Test
    public void testBooleanOperatorNotDeep() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("+(*:* NOT alpha) +charlie", Arrays.asList("charlie delta"));
    }

    @Test
    public void testBooleanOperatorOr() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("alpha OR charlie", Arrays.asList("alpha bravo", "alpha charlie", "charlie delta"));
        this.assertSearch("alpha OR delta", Arrays.asList("alpha bravo", "alpha charlie", "charlie delta"));
        this.assertSearch("bravo OR delta", Arrays.asList("alpha bravo", "charlie delta"));
    }

    @Test
    public void testBooleanOperatorOrWithNot() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("alpha OR NOT bravo", Arrays.asList("alpha charlie"));
    }

    @Test
    public void testField() throws Exception {
        this.addDocuments("java", "eclipse", "liferay");
        this.assertSearch("title:(java OR eclipse)", Arrays.asList("java", "eclipse"));
        this.assertSearch("description:(java OR eclipse)", Collections.emptyList());
    }

    @Test
    public void testPrefixOperatorMust() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("+alpha", Arrays.asList("alpha bravo", "alpha charlie"));
        this.assertSearch("+alpha bravo", Arrays.asList("alpha bravo", "alpha charlie"));
        this.assertSearch("+alpha +bravo", Arrays.asList("alpha bravo"));
        this.assertSearch("+alpha delta", Arrays.asList("alpha bravo", "alpha charlie"));
        this.assertSearch("+alpha +delta", Arrays.asList(new String[0]));
    }

    @Test
    public void testPrefixOperatorMustNot() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("-alpha", Arrays.asList("charlie delta"));
        this.assertSearch("-alpha bravo", Arrays.asList(new String[0]));
        this.assertSearch("-alpha -bravo", Arrays.asList("charlie delta"));
        this.assertSearch("-alpha delta", Arrays.asList("charlie delta"));
        this.assertSearch("-alpha -delta", Arrays.asList(new String[0]));
    }

    @Test
    public void testPrefixOperatorMustNotWithBooleanOperatorOr() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("(-bravo OR alpha)", Arrays.asList("alpha charlie"));
        this.assertSearch("-(bravo OR alpha)", Arrays.asList("charlie delta"));
        this.assertSearch("-(bravo) OR (alpha)", Arrays.asList("alpha charlie"));
        this.assertSearch("-(bravo) OR alpha", Arrays.asList("alpha charlie"));
        this.assertSearch("-bravo OR (alpha)", Arrays.asList("alpha charlie"));
        this.assertSearch("-bravo OR alpha", Arrays.asList("alpha charlie"));
    }

    @Test
    public void testStringQuery() {
        for (int i = 0; i < 10; ++i) {
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "SomeUser" + i));
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "OtherUser" + i));
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "Other" + i));
        }
        final StringQuery stringQuery = this.queries.string("SomeUser* OR OtherUser* ");
        stringQuery.setDefaultField("userName");
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)new SearchSearchRequest(){
                {
                    this.addSorts(new Sort[]{BaseStringQueryTestCase.this.sorts.field("userName")});
                    this.setIndexNames(new String[]{"_all"});
                    this.setQuery((Query)stringQuery);
                    this.setSize(30);
                }
            });
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)20L, (long)searchHits.getTotalHits());
            List searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals((String)"Retrieved hits", (long)20L, (long)searchHitsList.size());
            searchHitsList.forEach(searchHit -> {
                Document document = searchHit.getDocument();
                String userName = document.getString("userName");
                Assert.assertTrue((userName.startsWith("OtherUser") || userName.startsWith("SomeUser") ? 1 : 0) != 0);
            });
        });
    }

    protected void addDocuments(String ... values) throws Exception {
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(_FIELD_NAME, value), Arrays.asList(values));
    }

    protected void assertSearch(String queryString, List<String> expectedValues) {
        StringQuery stringQuery = this.queries.string(queryString);
        stringQuery.setDefaultField(_FIELD_NAME);
        TermQuery termQuery = this.queries.term("entryClassName", (Object)this.getEntryClassName());
        final BooleanQuery booleanQuery = this.queries.booleanQuery();
        booleanQuery.addFilterQueryClauses(new Query[]{stringQuery, termQuery});
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)new SearchSearchRequest(){
                {
                    this.addSorts(new Sort[]{BaseStringQueryTestCase.this.sorts.field("userName")});
                    this.setIndexNames(new String[]{"_all"});
                    this.setQuery((Query)booleanQuery);
                    this.setSize(30);
                }
            });
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            List searchHitsList = searchHits.getSearchHits();
            ArrayList actualValues = new ArrayList();
            searchHitsList.forEach(searchHit -> {
                Document document = searchHit.getDocument();
                actualValues.add(document.getString(_FIELD_NAME));
            });
            Assert.assertEquals((String)("Retrieved hits ->" + actualValues), (Object)expectedValues.toString(), (Object)((Object)actualValues).toString());
            Assert.assertEquals((String)"Retrieved hits", (long)expectedValues.size(), (long)searchHitsList.size());
            Assert.assertEquals((String)"Total hits", (long)expectedValues.size(), (long)searchHits.getTotalHits());
        });
    }
}

