/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.RangeTermQuery;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseRangeTermQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testRangeTermQuery() {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        final RangeTermQuery rangeTermQuery = this.queries.rangeTerm("priority", true, false);
        rangeTermQuery.setLowerBound((Object)5);
        rangeTermQuery.setUpperBound((Object)15);
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)new SearchSearchRequest(){
                {
                    this.addSorts(new Sort[]{BaseRangeTermQueryTestCase.this.sorts.field("priority")});
                    this.setIndexNames(new String[]{"_all"});
                    this.setQuery((Query)rangeTermQuery);
                    this.setSize(15);
                }
            });
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)10L, (long)searchHits.getTotalHits());
            List searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals((String)"Retrieved hits", (long)10L, (long)searchHitsList.size());
            int expectedValue = 5;
            for (SearchHit searchHit : searchHitsList) {
                Document document = searchHit.getDocument();
                Assert.assertEquals((String)"Priority value", (double)expectedValue, (double)document.getDouble("priority"), (double)0.0);
                ++expectedValue;
            }
        });
    }

    protected void addDocument(Date date) {
        this.addDocument(DocumentCreationHelpers.singleDate("expirationDate", date));
    }

    protected Date getDate(String date) {
        LocalDateTime localDateTime = LocalDateTime.parse(date);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }
}

