/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.IdsQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Test;

public abstract class BaseIdsQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testIdsQuery() {
        this.index(1, "alpha");
        this.index(2, "bravo");
        this.index(3, "charlie");
        this.index(4, "delta");
        IdsQuery idsQuery = this.queries.ids();
        idsQuery.addIds(new String[]{"1", "4"});
        FieldSort sort = this.sorts.field("userName", SortOrder.DESC);
        String expected = "[delta, alpha]";
        this.assertSearch(arg_0 -> this.lambda$testIdsQuery$0((Sort)sort, idsQuery, expected, arg_0));
    }

    protected Stream<Document> getDocumentsStream(SearchHits searchHits) {
        List list = searchHits.getSearchHits();
        Stream stream = list.stream();
        return stream.map(SearchHit::getDocument);
    }

    protected void index(int uid, String userName) {
        this.addDocument(document -> {
            document.addKeyword("uid", uid);
            document.addKeyword("userName", userName);
        });
    }

    private /* synthetic */ void lambda$testIdsQuery$0(final Sort sort, final IdsQuery idsQuery, String expected, BaseIndexingTestCase.IndexingTestHelper indexingTestHelper) {
        SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)new SearchSearchRequest(){
            {
                this.addSorts(new Sort[]{sort});
                this.setIndexNames(new String[]{"_all"});
                this.setQuery((Query)idsQuery);
            }
        });
        SearchHits searchHits = searchSearchResponse.getSearchHits();
        Stream<Document> stream = this.getDocumentsStream(searchHits);
        DocumentsAssert.assertValues(searchSearchResponse.getSearchRequestString(), stream, "userName", expected);
    }
}

