/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;

public abstract class BaseFieldQueryBuilderTestCase
extends BaseIndexingTestCase {
    protected void addDocument(String ... values) throws Exception {
        String[] transformed = this.transformFieldValues(values);
        if (transformed != null) {
            values = transformed;
        }
        this.addDocument(DocumentCreationHelpers.singleText(this.getField(), values));
        String[] values2 = values;
        this.assertSearch(indexingTestHelper -> {
            String keywords = values2[0];
            this.prepareSearch((BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper, keywords);
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> {
                Document[] documents = hits.getDocs();
                String field = this.getField();
                List<String> expectedValues = Arrays.asList(values2);
                ArrayList<String> actualValues = new ArrayList<String>();
                for (Document document : documents) {
                    List<String> documentValues = Arrays.asList(document.getValues(field));
                    if (documentValues.equals(expectedValues)) {
                        return;
                    }
                    actualValues.addAll(documentValues);
                }
                Assert.assertEquals((String)(keywords + "->" + actualValues), (Object)expectedValues.toString(), (Object)((Object)actualValues).toString());
            });
        });
    }

    protected void assertSearch(String keywords, int size) throws Exception {
        this._assertCount(keywords, size);
    }

    protected void assertSearch(String keywords, List<String> values) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            this.prepareSearch((BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper, keywords);
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> DocumentsAssert.assertValues(keywords, hits.getDocs(), this.getField(), values));
        });
    }

    protected void assertSearchCount(String keywords, int size) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            this.prepareSearch((BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper, keywords);
            long count = indexingTestHelper.searchCount();
            Assert.assertEquals((String)keywords, (long)size, (long)count);
        });
    }

    protected void assertSearchNoHits(String keywords) throws Exception {
        this._assertCount(keywords, 0);
    }

    protected Query buildQuery(String keywords) {
        FieldQueryBuilder fieldQueryBuilder = this.createFieldQueryBuilder();
        Query query = fieldQueryBuilder.build(this.getField(), keywords);
        this.setPreBooleanFilter((Filter)new TermFilter("companyId", String.valueOf(this.getCompanyId())), query);
        return query;
    }

    protected abstract FieldQueryBuilder createFieldQueryBuilder();

    protected Hits doSearch(String keywords) throws Exception {
        Query query = this.buildQuery(keywords);
        return this.search(this.createSearchContext(), query);
    }

    protected abstract String getField();

    protected void prepareSearch(BaseIndexingTestCase.IndexingTestHelper indexingTestHelper, String keywords) {
        Query query = this.buildQuery(keywords);
        indexingTestHelper.setQuery(query);
    }

    protected String[] transformFieldValues(String ... values) {
        return null;
    }

    private void _assertCount(String keywords, int size) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            this.prepareSearch((BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper, keywords);
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.size(Integer.valueOf(size + 1)));
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> DocumentsAssert.assertCount(keywords, hits.getDocs(), this.getField(), size));
        });
    }
}

