/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.document;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.Before;

public abstract class BaseDocumentTestCase
extends BaseIndexingTestCase {
    protected static final String FIELD_DOUBLE = "sd";
    protected static final String FIELD_DOUBLE_ARRAY = "md";
    protected static final String FIELD_FLOAT = "sf";
    protected static final String FIELD_FLOAT_ARRAY = "mf";
    protected static final String FIELD_INTEGER = "si";
    protected static final String FIELD_INTEGER_ARRAY = "mi";
    protected static final String FIELD_LONG = "sl";
    protected static final String FIELD_LONG_ARRAY = "ml";
    protected final Map<String, Double[]> doubleArrays = new HashMap<String, Double[]>();
    protected final Map<String, Double> doubles = new HashMap<String, Double>();
    protected final Map<String, Float[]> floatArrays = new HashMap<String, Float[]>();
    protected final Map<String, Float> floats = new HashMap<String, Float>();
    protected final Map<String, Integer[]> integerArrays = new HashMap<String, Integer[]>();
    protected final Map<String, Integer> integers = new HashMap<String, Integer>();
    protected final Map<String, Long[]> longArrays = new HashMap<String, Long[]>();
    protected final Map<String, Long> longs = new HashMap<String, Long>();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.populateNumberArrays();
        this.populateNumbers();
        this.addDocuments((String screenName) -> document -> this.populate(document, (String)screenName), this.getScreenNamesStream());
    }

    protected Stream<String> getScreenNamesStream() {
        Set<String> screenNames = this.doubles.keySet();
        return screenNames.stream();
    }

    protected void populate(Document document, String screenName) {
        document.addKeyword("firstName", screenName.replaceFirst("user", ""));
        document.addKeyword("lastName", "Smith");
        document.addText("screenName", screenName);
        document.addNumber(FIELD_DOUBLE, this.doubles.get(screenName));
        document.addNumber(FIELD_FLOAT, this.floats.get(screenName));
        document.addNumber(FIELD_INTEGER, this.integers.get(screenName));
        document.addNumber(FIELD_LONG, this.longs.get(screenName));
        document.addNumber(FIELD_DOUBLE_ARRAY, this.doubleArrays.get(screenName));
        document.addNumber(FIELD_FLOAT_ARRAY, this.floatArrays.get(screenName));
        document.addNumber(FIELD_INTEGER_ARRAY, this.integerArrays.get(screenName));
        document.addNumber(FIELD_LONG_ARRAY, this.longArrays.get(screenName));
    }

    protected void populateNumberArrays() {
        this.populateNumberArrays("firstuser", new Double[]{1.0E-11, 2.0E-11, 3.0E-11}, new Float[]{Float.valueOf(8.0E-5f), Float.valueOf(8.0E-5f), Float.valueOf(8.0E-5f)}, new Integer[]{1, 2, 3}, new Long[]{-3L, -2L, -1L});
        this.populateNumberArrays("seconduser", new Double[]{1.0E-11, 2.0E-11, 5.0E-11}, new Float[]{Float.valueOf(9.0E-5f), Float.valueOf(8.0E-5f), Float.valueOf(7.0E-5f)}, new Integer[]{1, 3, 4}, new Long[]{-3L, -2L, -2L});
        this.populateNumberArrays("thirduser", new Double[]{1.0E-11, 3.0E-11, 2.0E-11}, new Float[]{Float.valueOf(9.0E-5f), Float.valueOf(8.0E-5f), Float.valueOf(9.0E-5f)}, new Integer[]{2, 1, 1}, new Long[]{-3L, -3L, -1L});
        this.populateNumberArrays("fourthuser", new Double[]{1.0E-11, 2.0E-11, 4.0E-11}, new Float[]{Float.valueOf(9.0E-5f), Float.valueOf(9.0E-5f), Float.valueOf(7.0E-5f)}, new Integer[]{1, 2, 4}, new Long[]{-3L, -3L, -2L});
        this.populateNumberArrays("fifthuser", new Double[]{1.0E-11, 3.0E-11, 1.0E-11}, new Float[]{Float.valueOf(9.0E-5f), Float.valueOf(9.0E-5f), Float.valueOf(8.0E-5f)}, new Integer[]{1, 4, 4}, new Long[]{-4L, -2L, -1L});
        this.populateNumberArrays("sixthuser", new Double[]{2.0E-11, 1.0E-11, 1.0E-11}, new Float[]{Float.valueOf(9.0E-5f), Float.valueOf(9.0E-5f), Float.valueOf(9.0E-5f)}, new Integer[]{2, 1, 2}, new Long[]{-4L, -2L, -2L});
    }

    protected void populateNumberArrays(String screenName, Double[] doubleArray, Float[] floatArray, Integer[] integerArray, Long[] longArray) {
        this.doubleArrays.put(screenName, doubleArray);
        this.floatArrays.put(screenName, floatArray);
        this.integerArrays.put(screenName, integerArray);
        this.longArrays.put(screenName, longArray);
    }

    protected void populateNumbers() {
        int maxInt = Integer.MAX_VALUE;
        long minLong = Long.MIN_VALUE;
        this.populateNumbers("firstuser", 1.0E-11, Float.valueOf(8.0E-5f), maxInt, minLong);
        this.populateNumbers("seconduser", 3.0E-11, Float.valueOf(7.0E-5f), maxInt - 1, minLong + 1L);
        this.populateNumbers("thirduser", 5.0E-11, Float.valueOf(6.0E-5f), maxInt - 2, minLong + 2L);
        this.populateNumbers("fourthuser", 2.0E-11, Float.valueOf(5.0E-5f), maxInt - 3, minLong + 3L);
        this.populateNumbers("fifthuser", 4.0E-11, Float.valueOf(4.0E-5f), maxInt - 4, minLong + 4L);
        this.populateNumbers("sixthuser", 6.0E-11, Float.valueOf(3.0E-5f), maxInt - 5, minLong + 5L);
    }

    protected void populateNumbers(String screenName, Double numberDouble, Float floatNumber, Integer numberInteger, Long longNumber) {
        this.doubles.put(screenName, numberDouble);
        this.floats.put(screenName, floatNumber);
        this.integers.put(screenName, numberInteger);
        this.longs.put(screenName, longNumber);
    }
}

