/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.CumulativeSumPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.CumulativeSumPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseCumulativeSumPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testCumulativeSum() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        HistogramAggregation histogramAggregation = this.aggregationFixture.getDefaultHistogramAggregation();
        CumulativeSumPipelineAggregation cumulativeSumPipelineAggregation = this.aggregations.cumulativeSum("cumulative_sum", "sum");
        histogramAggregation.addPipelineAggregation((PipelineAggregation)cumulativeSumPipelineAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)histogramAggregation));
            indexingTestHelper.search();
            HistogramAggregationResult histogramAggregationResult = (HistogramAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)histogramAggregation);
            ArrayList buckets = new ArrayList(histogramAggregationResult.getBuckets());
            Assert.assertEquals((String)"Number of buckets", (long)5L, (long)buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "0.0", 4L, 10.0);
            this.assertBucket((Bucket)buckets.get(1), "5.0", 5L, 45.0);
            this.assertBucket((Bucket)buckets.get(2), "10.0", 5L, 105.0);
            this.assertBucket((Bucket)buckets.get(3), "15.0", 5L, 190.0);
            this.assertBucket((Bucket)buckets.get(4), "20.0", 1L, 210.0);
        });
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount, Double cumulativeSum) {
        Assert.assertEquals((Object)expectedKey, (Object)bucket.getKey());
        Assert.assertEquals((long)expectedCount, (long)bucket.getDocCount());
        Map childrenAggregationResults = bucket.getChildrenAggregationResults();
        CumulativeSumPipelineAggregationResult cumulativeSumPipelineAggregationResult = (CumulativeSumPipelineAggregationResult)childrenAggregationResults.get("cumulative_sum");
        if (cumulativeSum != null) {
            Assert.assertNotNull((Object)cumulativeSumPipelineAggregationResult);
            Assert.assertEquals((String)"Cumulative sum value", (double)cumulativeSum, (double)cumulativeSumPipelineAggregationResult.getValue(), (double)0.0);
        }
    }
}

