/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.metrics.StatsAggregation;
import com.liferay.portal.search.aggregation.metrics.StatsAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseStatsAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testStatsAggregation() throws Exception {
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 50.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 100.0));
        StatsAggregation statsAggregation = this.aggregations.stats("stats", "priority");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)statsAggregation));
            indexingTestHelper.search();
            StatsAggregationResult statsAggregationResult = (StatsAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)statsAggregation);
            Assert.assertEquals((double)75.0, (double)statsAggregationResult.getAvg(), (double)0.0);
            Assert.assertEquals((long)2L, (long)statsAggregationResult.getCount());
            Assert.assertEquals((double)100.0, (double)statsAggregationResult.getMax(), (double)0.0);
            Assert.assertEquals((double)50.0, (double)statsAggregationResult.getMin(), (double)0.0);
            Assert.assertEquals((double)150.0, (double)statsAggregationResult.getSum(), (double)0.0);
        });
    }
}

