/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.GlobalAggregation;
import com.liferay.portal.search.aggregation.bucket.GlobalAggregationResult;
import com.liferay.portal.search.aggregation.metrics.AvgAggregation;
import com.liferay.portal.search.aggregation.metrics.AvgAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseGlobalAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testGlobalAggregation() throws Exception {
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 2);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 3);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 4);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 5);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 6);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 7);
        });
        GlobalAggregation globalAggregation = this.aggregations.global("global");
        AvgAggregation avgAggregation = this.aggregations.avg("avg", "priority");
        globalAggregation.addChildAggregation((Aggregation)avgAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)globalAggregation));
            indexingTestHelper.search();
            GlobalAggregationResult globalAggregationResult = (GlobalAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)globalAggregation);
            Assert.assertEquals((float)7.0f, (float)globalAggregationResult.getDocCount(), (float)0.0f);
            Map childrenAggregationResults = globalAggregationResult.getChildrenAggregationResultsMap();
            Assert.assertEquals((String)"Children aggregations", (long)1L, (long)childrenAggregationResults.size());
            AvgAggregationResult avgAggregationResult = (AvgAggregationResult)globalAggregationResult.getChildAggregationResult("avg");
            Assert.assertEquals((String)"Avg priority", (double)4.0, (double)avgAggregationResult.getValue(), (double)0.0);
        });
    }
}

