/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.search.test.util.HitsAssert;
import com.liferay.portal.search.test.util.SearchContextTestUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IndexerFixture<T> {
    private final Indexer<T> _indexer;

    public IndexerFixture(Class<T> clazz) {
        this._indexer = IndexerRegistryUtil.getIndexer(clazz);
    }

    public void deleteDocument(Document document) {
        try {
            IndexWriterHelperUtil.deleteDocument((String)this._indexer.getSearchEngineId(), (long)TestPropsValues.getCompanyId(), (String)document.getUID(), (boolean)true);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    public void deleteDocuments(Document[] docs) {
        try {
            Stream<Document> stream = Arrays.stream(docs);
            List uids = stream.map(document -> document.getUID()).collect(Collectors.toList());
            IndexWriterHelperUtil.deleteDocuments((String)this._indexer.getSearchEngineId(), (long)TestPropsValues.getCompanyId(), uids, (boolean)true);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    public void reindex(long companyId) throws Exception {
        this._indexer.reindex(new String[]{String.valueOf(companyId)});
    }

    public Document[] search(long userId, String keywords, Locale locale) {
        try {
            SearchContext searchContext = SearchContextTestUtil.getSearchContext(userId, keywords, locale);
            Hits hits = this._indexer.search(searchContext);
            return hits.getDocs();
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    public Document[] search(String keywords) {
        try {
            return this.search(TestPropsValues.getUserId(), keywords, null);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    public void searchNoOne(long userId, String keywords, Locale locale) {
        this.searchNoOne(userId, keywords, locale, null);
    }

    public void searchNoOne(long userId, String keywords, Locale locale, Map<String, Serializable> attributes) {
        try {
            SearchContext searchContext = SearchContextTestUtil.getSearchContext(userId, null, keywords, locale, attributes);
            Hits hits = this._indexer.search(searchContext);
            HitsAssert.assertNoHits(hits);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    public void searchNoOne(String keywords) {
        this.searchNoOne(keywords, null);
    }

    public void searchNoOne(String keywords, Locale locale) {
        this.searchNoOne(keywords, locale, null);
    }

    public void searchNoOne(String keywords, Locale locale, Map<String, Serializable> attributes) {
        try {
            this.searchNoOne(TestPropsValues.getUserId(), keywords, locale, attributes);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    public Document searchOnlyOne(long userId, String keywords, Locale locale) {
        return this.searchOnlyOne(userId, keywords, locale, null);
    }

    public Document searchOnlyOne(long userId, String keywords, Locale locale, Map<String, Serializable> attributes) {
        try {
            SearchContext searchContext = SearchContextTestUtil.getSearchContext(userId, null, keywords, locale, attributes);
            Hits hits = this._indexer.search(searchContext);
            return HitsAssert.assertOnlyOne(hits);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    public Document searchOnlyOne(String keywords) {
        return this.searchOnlyOne(keywords, null, null);
    }

    public Document searchOnlyOne(String keywords, Locale locale) {
        return this.searchOnlyOne(keywords, locale, null);
    }

    public Document searchOnlyOne(String keywords, Locale locale, Map<String, Serializable> attributes) {
        try {
            return this.searchOnlyOne(TestPropsValues.getUserId(), keywords, locale, attributes);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    public Document searchOnlyOne(String keywords, Map<String, Serializable> attributes) {
        return this.searchOnlyOne(keywords, null, attributes);
    }
}

