/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.suggest;

import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSuggestTestCase
extends BaseIndexingTestCase {
    @Test
    public void testMultipleWords() throws Exception {
        this.indexSuccessfulQuery("indexed this phrase");
        this.assertSuggest("[indexed this phrase]", "indexef   this   phrasd");
    }

    @Test
    public void testNothingToSuggest() throws Exception {
        this.assertSuggest("[]", "nothign");
    }

    @Test
    public void testNull() throws Exception {
        this.assertSuggest("[]", null);
    }

    protected void assertSuggest(String expectedSuggestions, String keywords) throws Exception {
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, () -> {
            Assert.assertEquals((Object)expectedSuggestions, (Object)String.valueOf(Arrays.asList(this.suggestKeywordQueries(keywords))));
            return null;
        });
    }

    protected SearchContext createSearchContext(String keywords) {
        SearchContext searchContext = BaseSuggestTestCase.createSearchContext();
        searchContext.setKeywords(keywords);
        return searchContext;
    }

    protected void indexSuccessfulQuery(String value) throws Exception {
        IndexWriter spellCheckIndexWriter = this.getIndexWriter();
        spellCheckIndexWriter.indexKeyword(this.createSearchContext(value), 0.0f, "querySuggestion");
    }

    protected String[] suggestKeywordQueries(SearchContext searchContext, int max) throws Exception {
        IndexSearcher querySuggester = this.getIndexSearcher();
        return querySuggester.suggestKeywordQueries(searchContext, max);
    }

    protected String[] suggestKeywordQueries(String keywords) throws Exception {
        return this.suggestKeywordQueries(this.createSearchContext(keywords), 1);
    }
}

