/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.spellcheck;

import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSpellCheckTestCase
extends BaseIndexingTestCase {
    @Test
    public void testJapaneseIdeographicSpace() throws Exception {
        String ideographicSpace = "\u3000";
        this.spellCheckKeywords("\u3042" + ideographicSpace + "\u3044");
        this.spellCheckKeywords("\u3042" + ideographicSpace + ideographicSpace + "\u3044");
        this.spellCheckKeywords("A" + ideographicSpace + "B");
    }

    @Test
    public void testLuceneUnfriendlyTerms() throws Exception {
        this.spellCheckKeywords("+alpha AND -bravo");
    }

    @Test
    public void testMultipleWords() throws Exception {
        this.indexSpellCheckWord("liferay");
        this.indexSpellCheckWord("search");
        this.assertSpellCheck("search liferay", "searc lifera");
    }

    @Test
    public void testMultipleWordsMap() throws Exception {
        this.indexSpellCheckWord("liferay");
        this.indexSpellCheckWord("search");
        this.assertSpellCheckMap("{searc=[search], lifera=[liferay]}", "searc lifera");
    }

    @Test
    public void testQuotedWords() throws Exception {
        this.indexSpellCheckWord("liferay");
        this.indexSpellCheckWord("search");
        this.assertSpellCheck("liferay", "\"lifera\"");
        this.assertSpellCheck("liferay search", "\"lifera searc\"");
    }

    @Test
    public void testRepeated() throws Exception {
        this.indexSpellCheckWord("liferay");
        this.indexSpellCheckWord("search");
        this.assertSpellCheck("liferay search liferay search", "lifera searc lifera searc");
    }

    @Test
    public void testRepeatedMap() throws Exception {
        this.indexSpellCheckWord("liferay");
        this.indexSpellCheckWord("search");
        this.assertSpellCheckMap("{lifera=[liferay], searc=[search]}", "lifera searc lifera searc");
    }

    @Test
    public void testShortTerms() throws Exception {
        this.spellCheckKeywords("1 2");
        this.spellCheckKeywords("A B");
        this.spellCheckKeywords("A  B");
    }

    @Test
    public void testSpellCheck() throws Exception {
        this.indexSpellCheckWord("liferay");
        this.assertSpellCheck("liferay", "lifera");
    }

    @Test
    public void testSpellCheckMap() throws Exception {
        this.indexSpellCheckWord("liferay");
        this.assertSpellCheckMap("{lifera=[liferay]}", "lifera");
    }

    @Test
    public void testWhitespace() throws Exception {
        this.indexSpellCheckWord("liferay");
        this.indexSpellCheckWord("search");
        this.assertSpellCheck("liferay search", "Lifera Searc");
        this.assertSpellCheck("liferay search", " Lifera Searc   ");
        this.assertSpellCheck("liferay search", "Lifera    Searc");
    }

    @Test
    public void testWhitespaceMap() throws Exception {
        this.indexSpellCheckWord("liferay");
        this.indexSpellCheckWord("search");
        this.assertSpellCheckMap("{l=[], ife=[], ray=[], searc=[search], h=[]}", "L ife  ray    Searc h");
    }

    protected void assertSpellCheck(String expectedSpelling, String keywords) throws Exception {
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, () -> {
            Assert.assertEquals((Object)expectedSpelling, (Object)this.spellCheckKeywords(this.createSearchContext(keywords)));
            return null;
        });
    }

    protected void assertSpellCheckMap(String expectedMapString, String keywords) throws Exception {
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, () -> {
            Assert.assertEquals((Object)expectedMapString, (Object)String.valueOf(this.spellCheckKeywords(keywords)));
            return null;
        });
    }

    protected SearchContext createSearchContext(String keywords) {
        SearchContext searchContext = BaseSpellCheckTestCase.createSearchContext();
        searchContext.setKeywords(keywords);
        return searchContext;
    }

    protected void indexSpellCheckWord(String value) throws Exception {
        this.indexSpellCheckWord(value, 0.0f);
    }

    protected void indexSpellCheckWord(String value, float weight) throws SearchException {
        IndexWriter spellCheckIndexWriter = this.getIndexWriter();
        spellCheckIndexWriter.indexKeyword(this.createSearchContext(value), weight, "spellChecker");
    }

    protected String spellCheckKeywords(SearchContext searchContext) throws Exception {
        IndexSearcher querySuggester = this.getIndexSearcher();
        return querySuggester.spellCheckKeywords(searchContext);
    }

    protected Map<String, List<String>> spellCheckKeywords(SearchContext searchContext, int max) throws Exception {
        IndexSearcher querySuggester = this.getIndexSearcher();
        return querySuggester.spellCheckKeywords(searchContext, max);
    }

    protected Map<String, List<String>> spellCheckKeywords(String keywords) throws Exception {
        return this.spellCheckKeywords(this.createSearchContext(keywords), 2);
    }
}

