/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.sort;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.search.internal.SortFactoryImpl;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelper;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.Test;

public abstract class BaseSortTestCase
extends BaseIndexingTestCase {
    @Test
    public void testDefaultSorts() throws Exception {
        double[] values = new double[]{1.0, 2.0, 3.0};
        this.addDocuments((Double value) -> document -> {
            document.addDate("modified", new Date(value.longValue()));
            document.addNumber("priority", value);
        }, values);
        SearchContext searchContext = BaseSortTestCase.createSearchContext();
        SortFactoryImpl sortFactory = new SortFactoryImpl();
        searchContext.setSorts(sortFactory.getDefaultSorts());
        this.assertOrder("priority", searchContext, Arrays.asList("3.0", "2.0", "1.0"));
    }

    @Test
    public void testPriorityField() throws Exception {
        this.testDoubleField("priority");
    }

    @Test
    public void testPriorityFieldSortable() throws Exception {
        this.testDoubleFieldSortable("priority");
    }

    protected void addDocuments(Function<Double, DocumentCreationHelper> function, double ... values) throws Exception {
        for (double value : values) {
            this.addDocument(function.apply(value));
        }
    }

    protected void assertOrder(String fieldName, int sortType, List<String> expectedValues) throws Exception {
        SearchContext searchContext = BaseSortTestCase.createSearchContext();
        searchContext.setSorts(new Sort[]{new Sort(fieldName, sortType, false)});
        this.assertOrder(fieldName, searchContext, expectedValues);
    }

    protected void assertOrder(String fieldName, SearchContext searchContext, List<String> expectedValues) throws Exception {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.addSelectedFieldNames(new String[]{fieldName});
        Query query = this.getDefaultQuery();
        query.setQueryConfig(queryConfig);
        IdempotentRetryAssert.retryAssert(5L, TimeUnit.SECONDS, () -> {
            Hits hits = this.search(searchContext, query);
            DocumentsAssert.assertValues((String)((Object)searchContext.getAttribute("queryString")), hits.getDocs(), fieldName, expectedValues);
            return null;
        });
    }

    protected void testDoubleField(String fieldName) throws Exception {
        this.testDoubleField(fieldName, value -> DocumentCreationHelpers.singleNumber(fieldName, value));
    }

    protected void testDoubleField(String fieldName, Function<Double, DocumentCreationHelper> function) throws Exception {
        double[] values = new double[]{10.0, 1.0, 40.0, 5.3};
        this.addDocuments(function, values);
        this.assertOrder(fieldName, 7, Arrays.asList("1.0", "5.3", "10.0", "40.0"));
    }

    protected void testDoubleFieldSortable(String fieldName) throws Exception {
        this.testDoubleField(fieldName, value -> DocumentCreationHelpers.singleNumberSortable(fieldName, value));
    }
}

