/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.StringQuery;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public abstract class BaseStringQueryTestCase
extends BaseIndexingTestCase {
    private static final String _FIELD_NAME = "title";

    @Test
    public void testBooleanOperatorAnd() throws Exception {
        this.addDocuments("java eclipse", "java liferay", "java liferay eclipse");
        this.assertSearch("java AND eclipse", Arrays.asList("java eclipse", "java liferay eclipse"));
        this.assertSearch("eclipse AND liferay", Arrays.asList("java liferay eclipse"));
    }

    @Test
    public void testBooleanOperatorAndWithNot() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("alpha AND NOT bravo", Arrays.asList("alpha charlie"));
    }

    @Test
    public void testBooleanOperatorNot() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("NOT alpha", Arrays.asList("charlie delta"));
        this.assertSearch("NOT bravo", Arrays.asList("alpha charlie", "charlie delta"));
    }

    @Test
    public void testBooleanOperatorNotDeep() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("+(*:* NOT alpha) +charlie", Arrays.asList("charlie delta"));
    }

    @Test
    public void testBooleanOperatorOr() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("alpha OR charlie", Arrays.asList("alpha charlie", "alpha bravo", "charlie delta"));
        this.assertSearch("alpha OR delta", Arrays.asList("charlie delta", "alpha bravo", "alpha charlie"));
        this.assertSearch("bravo OR delta", Arrays.asList("alpha bravo", "charlie delta"));
    }

    @Test
    public void testBooleanOperatorOrWithNot() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("alpha OR NOT bravo", Arrays.asList("alpha charlie"));
    }

    @Test
    public void testField() throws Exception {
        this.addDocuments("java", "eclipse", "liferay");
        this.assertSearch("title:(java OR eclipse)", Arrays.asList("java", "eclipse"));
        this.assertSearch("description:(java OR eclipse)", Collections.emptyList());
    }

    @Test
    public void testPrefixOperatorMust() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("+alpha", Arrays.asList("alpha bravo", "alpha charlie"));
        this.assertSearch("+alpha bravo", Arrays.asList("alpha bravo", "alpha charlie"));
        this.assertSearch("+alpha +bravo", Arrays.asList("alpha bravo"));
        this.assertSearch("+alpha delta", Arrays.asList("alpha bravo", "alpha charlie"));
        this.assertSearch("+alpha +delta", Arrays.asList(new String[0]));
    }

    @Test
    public void testPrefixOperatorMustNot() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("-alpha", Arrays.asList("charlie delta"));
        this.assertSearch("-alpha bravo", Arrays.asList(new String[0]));
        this.assertSearch("-alpha -bravo", Arrays.asList("charlie delta"));
        this.assertSearch("-alpha delta", Arrays.asList("charlie delta"));
        this.assertSearch("-alpha -delta", Arrays.asList(new String[0]));
    }

    @Test
    public void testPrefixOperatorMustNotWithBooleanOperatorOr() throws Exception {
        this.addDocuments("alpha bravo", "alpha charlie", "charlie delta");
        this.assertSearch("(-bravo OR alpha)", Arrays.asList("alpha charlie"));
        this.assertSearch("-(bravo OR alpha)", Arrays.asList("charlie delta"));
        this.assertSearch("-(bravo) OR (alpha)", Arrays.asList("alpha charlie"));
        this.assertSearch("-(bravo) OR alpha", Arrays.asList("alpha charlie"));
        this.assertSearch("-bravo OR (alpha)", Arrays.asList("alpha charlie"));
        this.assertSearch("-bravo OR alpha", Arrays.asList("alpha charlie"));
    }

    protected void addDocuments(String ... values) throws Exception {
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(_FIELD_NAME, value), Arrays.asList(values));
    }

    protected void assertSearch(String query, List<String> expectedValues) throws Exception {
        IdempotentRetryAssert.retryAssert(5L, TimeUnit.SECONDS, () -> this.doAssertSearch(query, expectedValues));
    }

    protected Void doAssertSearch(String query, List<String> expectedValues) throws Exception {
        SearchContext searchContext = BaseStringQueryTestCase.createSearchContext();
        StringQuery stringQuery = this._createStringQuery(query, searchContext);
        Hits hits = this.search(searchContext, (Query)stringQuery);
        DocumentsAssert.assertValues(query, hits.getDocs(), _FIELD_NAME, expectedValues);
        return null;
    }

    private StringQuery _createStringQuery(String query, SearchContext searchContext) {
        StringQuery stringQuery = new StringQuery(query);
        stringQuery.setQueryConfig(searchContext.getQueryConfig());
        return stringQuery;
    }
}

