/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.pagination;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistry;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchResultPermissionFilter;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.facet.FacetPostProcessor;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.configuration.DefaultSearchResultPermissionFilterConfiguration;
import com.liferay.portal.search.internal.facet.FacetPostProcessorImpl;
import com.liferay.portal.search.internal.permission.DefaultSearchResultPermissionFilter;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.AdditionalMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;

public abstract class BasePermissionFilteredPaginationTestCase
extends BaseIndexingTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    protected int permissionFilteredSearchResultAccurateCountThreshold;
    protected int searchQueryResultWindowLimit;
    private static final long _FILTERED_ENTRY_IDENTIFIER = 1000000L;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.permissionFilteredSearchResultAccurateCountThreshold = 9;
        this.searchQueryResultWindowLimit = 9;
    }

    @Test
    public void testAccurateCountThreshold() throws Exception {
        this.index(9, this.filtering(4));
        this.permissionFilteredSearchResultAccurateCountThreshold = 4;
        this.assertPaginationCounts(1, 9, 3, "[8, 8, 8]");
    }

    @Test
    public void testAccurateCountThresholdLessThanExpectedFiltered() throws Exception {
        this.index(9, this.filtering(4));
        this.permissionFilteredSearchResultAccurateCountThreshold = 3;
        this.assertPaginationCounts(1, 9, 3, "[9, 8, 8]");
    }

    @Test
    public void testAccurateCountThresholdMoreThanExpectedFiltered() throws Exception {
        this.index(9, this.filtering(4));
        this.permissionFilteredSearchResultAccurateCountThreshold = 5;
        this.assertPaginationCounts(1, 9, 3, "[8, 8, 8]");
    }

    @Test
    public void testAccurateCountThresholdNegativeOne() throws Exception {
        this.index(9, this.filtering(4));
        this.permissionFilteredSearchResultAccurateCountThreshold = -1;
        this.assertPaginationCounts(1, 9, 3, "[9, 8, 8]");
    }

    @Test
    public void testAccurateCountThresholdZero() throws Exception {
        this.index(9, this.filtering(4));
        this.permissionFilteredSearchResultAccurateCountThreshold = 0;
        this.assertPaginationCounts(1, 9, 3, "[9, 8, 8]");
    }

    @Test
    public void testExcludeEveryThird() throws Exception {
        this.index(9, this.filtering(3, 6, 9));
        this.assertPagination(1, 9, 3, "[[1, 2, 4], [5, 7, 8]]");
    }

    @Test
    public void testExcludeFirst() throws Exception {
        this.index(9, this.filtering(1));
        this.assertPagination(1, 9, 3, "[[2, 3, 4], [5, 6, 7], [8, 9]]");
    }

    @Test
    public void testExcludeLast() throws Exception {
        this.index(9, this.filtering(9));
        this.assertPagination(1, 9, 3, "[[1, 2, 3], [4, 5, 6], [7, 8]]");
    }

    @Test
    public void testExcludeMiddle() throws Exception {
        this.index(9, this.filtering(2, 3, 4, 5, 6, 7, 8));
        this.assertPagination(1, 9, 3, "[[1, 9]]");
    }

    @Test
    public void testMinimal() throws Exception {
        this.index(3, this.filtering(new Integer[0]));
        this.assertPagination(1, 3, 1, "[[1], [2], [3]]");
    }

    @Test
    public void testMinimalEndFirstIndex() throws Exception {
        this.index(3, this.filtering(new Integer[0]));
        this.assertPagination(1, 1, 1, "[[1]]");
    }

    @Test
    public void testMinimalEndMiddleIndex() throws Exception {
        this.index(3, this.filtering(new Integer[0]));
        this.assertPagination(1, 2, 1, "[[1], [2]]");
    }

    @Test
    public void testMinimalStartLastIndex() throws Exception {
        this.index(3, this.filtering(new Integer[0]));
        this.assertPagination(3, 3, 1, "[[3]]");
    }

    @Test
    public void testMinimalStartMiddleIndex() throws Exception {
        this.index(3, this.filtering(new Integer[0]));
        this.assertPagination(2, 3, 1, "[[2], [3]]");
    }

    @Test
    public void testPastLast() throws Exception {
        this.index(9, this.filtering(new Integer[0]));
        this.assertPagination(10, 12, 3, "[[7, 8, 9]]");
    }

    @Test
    public void testPastLastSecondIndex() throws Exception {
        this.index(9, this.filtering(new Integer[0]));
        this.assertPagination(11, 12, 3, "[[9]]");
    }

    @Test
    public void testPastLastThirdIndex() throws Exception {
        this.index(9, this.filtering(new Integer[0]));
        this.assertPagination(12, 12, 3, "[[9]]");
    }

    @Test
    public void testSearchQueryResultWindowLimitNegativeOne() throws Exception {
        this.index(9, this.filtering(new Integer[0]));
        this.searchQueryResultWindowLimit = -1;
        this.expectedException.expect(SystemException.class);
        this.expectedException.expectMessage("Search result window size of 9 exceeds the configured limit of -1");
        this.assertPagination(1, 1, 1, "[[1]]");
    }

    @Test
    public void testSearchQueryResultWindowLimitZero() throws Exception {
        this.index(9, this.filtering(new Integer[0]));
        this.searchQueryResultWindowLimit = 0;
        this.expectedException.expect(SystemException.class);
        this.expectedException.expectMessage("Search result window size of 9 exceeds the configured limit of 0");
        this.assertPagination(1, 1, 1, "[[1]]");
    }

    @Test
    public void testSlidingWindow() throws Exception {
        this.index(9, this.filtering(1, 2, 3, 4, 5, 6, 7, 8));
        this.searchQueryResultWindowLimit = 3;
        this.assertPagination(1, 9, 9, "[[9]]");
    }

    protected void assertPagination(int from, int to, int pageSize, String expectedPaginationResult) throws Exception {
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, () -> {
            this.doAssertPagination(from, to, pageSize, expectedPaginationResult);
            return null;
        });
    }

    protected void assertPaginationCounts(int from, int to, int pageSize, String expectedPaginationCountsResult) throws Exception {
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, () -> {
            this.doAssertPaginationCounts(from, to, pageSize, expectedPaginationCountsResult);
            return null;
        });
    }

    protected List<Integer> createEntries(int totalEntries) {
        ArrayList<Integer> entries = new ArrayList<Integer>(totalEntries);
        for (int i = 1; i <= totalEntries; ++i) {
            entries.add(i);
        }
        return entries;
    }

    protected SearchContext createSearchContext(int start, int end) {
        SearchContext searchContext = BasePermissionFilteredPaginationTestCase.createSearchContext();
        searchContext.setEnd(end);
        searchContext.setStart(start);
        searchContext.setSorts(new Sort[]{new Sort(null, 0, false), new Sort("modified", 6, true)});
        return searchContext;
    }

    protected SearchResultPermissionFilter createSearchResultPermissionFilter() throws Exception {
        IndexerRegistry indexerRegistry = (IndexerRegistry)Mockito.mock(IndexerRegistry.class);
        PermissionChecker permissionChecker = (PermissionChecker)Mockito.mock(PermissionChecker.class);
        Props props = (Props)Mockito.mock(Props.class);
        RelatedEntryIndexerRegistry relatedEntryIndexerRegistry = (RelatedEntryIndexerRegistry)Mockito.mock(RelatedEntryIndexerRegistry.class);
        DefaultSearchResultPermissionFilterConfiguration defaultSearchResultPermissionFilterConfiguration = (DefaultSearchResultPermissionFilterConfiguration)Mockito.mock(DefaultSearchResultPermissionFilterConfiguration.class);
        this.setUpSearchResultPermissionFilterMocks(indexerRegistry, permissionChecker, props, defaultSearchResultPermissionFilterConfiguration);
        return new DefaultSearchResultPermissionFilter((FacetPostProcessor)new FacetPostProcessorImpl(), indexerRegistry, permissionChecker, props, relatedEntryIndexerRegistry, this::doSearch, defaultSearchResultPermissionFilterConfiguration);
    }

    protected void doAssertPagination(int from, int to, int pageSize, String expected) throws Exception {
        int pageCount = StringUtil.count((String)expected, (char)'[') - 1;
        Assert.assertTrue((pageCount > 0 ? 1 : 0) != 0);
        ArrayList<List<Integer>> paginatedEntries = new ArrayList<List<Integer>>();
        for (int page = 1; page <= pageCount; ++page) {
            int start = from - 1 + (page - 1) * pageSize;
            int end = start + pageSize;
            if (end > to) {
                end = to;
            }
            Hits hits = this.searchFilteredPagination(start, end);
            List<Integer> entries = this.getEntries(hits);
            paginatedEntries.add(entries);
        }
        String actual = ((Object)paginatedEntries).toString();
        Assert.assertEquals((String)actual, (Object)expected, (Object)actual);
    }

    protected void doAssertPaginationCounts(int from, int to, int pageSize, String expected) throws Exception {
        int pageCount = StringUtil.count((String)expected, (char)',') + 1;
        Assert.assertTrue((pageCount > 0 ? 1 : 0) != 0);
        ArrayList<Integer> paginatedCounts = new ArrayList<Integer>();
        for (int page = 1; page <= pageCount; ++page) {
            int start = from - 1 + (page - 1) * pageSize;
            int end = start + pageSize;
            if (end > to) {
                end = to;
            }
            Hits hits = this.searchFilteredPagination(start, end);
            paginatedCounts.add(hits.getLength());
        }
        String actual = ((Object)paginatedCounts).toString();
        Assert.assertEquals((String)actual, (Object)expected, (Object)actual);
    }

    protected Hits doSearch(SearchContext searchContext) {
        try {
            return this.search(searchContext);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Integer> filtering(Integer ... entries) {
        return Arrays.asList(entries);
    }

    protected long getDocumentEntryClassPK(Document document) {
        return GetterUtil.getLong((String)document.get("entryClassPK"));
    }

    protected List<Integer> getEntries(Hits hits) {
        ArrayList<Integer> entries = new ArrayList<Integer>();
        for (Document document : hits.getDocs()) {
            long entry = this.getDocumentEntryClassPK(document);
            if (entry >= 1000000L) {
                entry -= 1000000L;
            }
            entries.add((int)entry);
        }
        return entries;
    }

    protected void index(int totalEntries, List<Integer> filteredEntries) throws Exception {
        List<Integer> entries = this.createEntries(totalEntries);
        this.indexEntries(entries, filteredEntries);
    }

    protected void indexEntries(List<Integer> entries, List<Integer> filteredEntries) throws Exception {
        for (Integer entry : entries) {
            long entryClassPK = entry.intValue();
            if (filteredEntries.contains(entry)) {
                entryClassPK += 1000000L;
            }
            this.addDocument(DocumentCreationHelpers.singleKeyword("entryClassPK", String.valueOf(entryClassPK)));
        }
    }

    protected Hits searchFilteredPagination(int start, int end) throws Exception {
        SearchResultPermissionFilter searchResultPermissionFilter = this.createSearchResultPermissionFilter();
        return searchResultPermissionFilter.search(this.createSearchContext(start, end));
    }

    protected void setUpSearchResultPermissionFilterMocks(IndexerRegistry indexerRegistry, PermissionChecker permissionChecker, Props props, DefaultSearchResultPermissionFilterConfiguration defaultSearchResultPermissionFilterConfiguration) throws Exception {
        Indexer indexer = (Indexer)Mockito.mock(Indexer.class);
        Mockito.when((Object)indexer.hasPermission((PermissionChecker)Matchers.any(PermissionChecker.class), Matchers.anyString(), Matchers.anyLong(), Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)indexer.hasPermission((PermissionChecker)Matchers.any(PermissionChecker.class), Matchers.anyString(), AdditionalMatchers.geq((long)1000000L), Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)indexer.isFilterSearch()).thenReturn((Object)true);
        Mockito.when((Object)indexerRegistry.getIndexer(Matchers.anyString())).thenReturn((Object)indexer);
        Mockito.when((Object)permissionChecker.getCompanyId()).thenReturn((Object)COMPANY_ID);
        Mockito.when((Object)props.get("index.permission.filter.search.amplification.factor")).thenReturn((Object)"1.5");
        Mockito.when((Object)defaultSearchResultPermissionFilterConfiguration.permissionFilteredSearchResultAccurateCountThreshold()).thenReturn((Object)this.permissionFilteredSearchResultAccurateCountThreshold);
        Mockito.when((Object)defaultSearchResultPermissionFilterConfiguration.searchQueryResultWindowLimit()).thenReturn((Object)this.searchQueryResultWindowLimit);
    }
}

