/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.pagination;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.UniqueStringRandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class BasePaginationTestCase
extends BaseIndexingTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final int _TOTAL_DOCUMENTS = 20;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        for (int i = 0; i < 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleText("test-field", RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[]{UniqueStringRandomizerBumper.INSTANCE})));
        }
    }

    @Test
    public void testBadEnd() throws Exception {
        this._assertBadRange(-1, -2, "Invalid end -2");
    }

    @Test
    public void testBadStart() throws Exception {
        this._assertBadRange(-2, -1, "Invalid start -2");
    }

    @Test
    public void testFirst() throws Exception {
        this._assertPagination(0, 1, 1);
    }

    @Test
    public void testFirstUnbounded() throws Exception {
        this._assertPagination(-1, 1, 1);
    }

    @Test
    public void testLast() throws Exception {
        this._assertPagination(19, 20, 1);
    }

    @Test
    public void testLastUnbounded() throws Exception {
        this._assertPagination(19, -1, 1);
    }

    @Test
    public void testMiddle() throws Exception {
        this._assertPagination(5, 8, 3);
    }

    @Test
    public void testMiddleOne() throws Exception {
        this._assertPagination(5, 6, 1);
    }

    @Test
    public void testMiddleUntilPastLast() throws Exception {
        this._assertPagination(16, 24, 4);
    }

    @Test
    public void testNextToLast() throws Exception {
        this._assertPagination(18, 19, 1);
    }

    @Test
    public void testNone() throws Exception {
        this._assertPagination(0, 0, 0);
    }

    @Test
    public void testPastLast() throws Exception {
        this._assertPagination(20, 21, 1);
    }

    @Test
    public void testUnbounded() throws Exception {
        this._assertPagination(-1, -1, 20);
    }

    @Test
    public void testWayPastLast() throws Exception {
        this._assertPagination(25, 26, 1);
    }

    private void _assertBadRange(int start, int end, String message) throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(message);
        try {
            this.search(this._createSearchContext(start, end));
        }
        catch (SearchException se) {
            throw (Exception)se.getCause();
        }
    }

    private void _assertPagination(int start, int end, int expectedSize) throws Exception {
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, () -> {
            IndexSearcher indexSearcher = this.getIndexSearcher();
            SearchContext searchContext = this._createSearchContext(start, end);
            Hits hits = indexSearcher.search(searchContext, this.getDefaultQuery());
            Assert.assertEquals((String)hits.toString(), (long)20L, (long)hits.getLength());
            Object[] documents = hits.getDocs();
            Assert.assertEquals((String)Arrays.toString(documents), (long)expectedSize, (long)documents.length);
            return null;
        });
    }

    private SearchContext _createSearchContext(int start, int end) {
        SearchContext searchContext = BasePaginationTestCase.createSearchContext();
        searchContext.setEnd(end);
        searchContext.setStart(start);
        return searchContext;
    }
}

