/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public abstract class BaseFieldQueryBuilderTestCase
extends BaseIndexingTestCase {
    protected void addDocument(String ... values) throws Exception {
        String[] transformed = this.transformFieldValues(values);
        if (transformed != null) {
            values = transformed;
        }
        this.addDocument(DocumentCreationHelpers.singleText(this.getField(), values));
        final String[] expectedValues = values;
        IdempotentRetryAssert.retryAssert(5L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseFieldQueryBuilderTestCase.this._assertDocument(expectedValues);
                return null;
            }
        });
    }

    protected void assertSearch(final String keywords, final int size) throws Exception {
        IdempotentRetryAssert.retryAssert(5L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseFieldQueryBuilderTestCase.this._assertCount(keywords, size);
                return null;
            }
        });
    }

    protected void assertSearch(final String keywords, final List<String> values) throws Exception {
        IdempotentRetryAssert.retryAssert(5L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseFieldQueryBuilderTestCase.this._assertValues(keywords, values);
                return null;
            }
        });
    }

    protected void assertSearchNoHits(final String keywords) throws Exception {
        IdempotentRetryAssert.retryAssert(5L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseFieldQueryBuilderTestCase.this._assertNoHits(keywords);
                return null;
            }
        });
    }

    protected abstract FieldQueryBuilder createFieldQueryBuilder();

    protected Hits doSearch(String keywords) throws Exception {
        FieldQueryBuilder fieldQueryBuilder = this.createFieldQueryBuilder();
        Query query = fieldQueryBuilder.build(this.getField(), keywords);
        return this.search(BaseFieldQueryBuilderTestCase.createSearchContext(), query);
    }

    protected abstract String getField();

    protected String[] transformFieldValues(String ... values) {
        return null;
    }

    private void _assertCount(String keywords, int count) throws Exception {
        Hits hits = this.doSearch(keywords);
        DocumentsAssert.assertCount(keywords, hits.getDocs(), this.getField(), count);
    }

    private void _assertDocument(String ... values) throws Exception {
        String keywords = values[0];
        Hits hits = this.doSearch(keywords);
        Document[] documents = hits.getDocs();
        String field = this.getField();
        List<String> expectedValues = Arrays.asList(values);
        ArrayList<String> actualValues = new ArrayList<String>();
        for (Document document : documents) {
            List<String> documentValues = Arrays.asList(document.getValues(field));
            if (documentValues.equals(expectedValues)) {
                return;
            }
            actualValues.addAll(documentValues);
        }
        Assert.assertEquals((String)(keywords + "->" + actualValues), (Object)expectedValues.toString(), (Object)((Object)actualValues).toString());
    }

    private void _assertNoHits(String keywords) throws Exception {
        this._assertCount(keywords, 0);
    }

    private void _assertValues(String keywords, List<String> expectedValues) throws Exception {
        Hits hits = this.doSearch(keywords);
        DocumentsAssert.assertValues(keywords, hits.getDocs(), this.getField(), expectedValues);
    }
}

