/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.internal.analysis.DescriptionFieldQueryBuilder;
import com.liferay.portal.search.internal.analysis.SimpleKeywordTokenizer;
import com.liferay.portal.search.test.util.mappings.BaseFieldQueryBuilderTestCase;
import java.util.Arrays;

public abstract class BaseDescriptionFieldQueryBuilderTestCase
extends BaseFieldQueryBuilderTestCase {
    @Override
    protected FieldQueryBuilder createFieldQueryBuilder() {
        return new DescriptionFieldQueryBuilder(){
            {
                this.keywordTokenizer = new SimpleKeywordTokenizer();
            }
        };
    }

    @Override
    protected String getField() {
        return "description";
    }

    protected void testBasicWordMatches() throws Exception {
        this.addDocument("LOOKing for DOCUments");
        this.addDocument("this is a test for description");
        this.addDocument("Description Test");
        this.addDocument("TESTING THE DESCRIPTION");
        this.assertSearch("description", 3);
        this.assertSearch("for", 2);
        this.assertSearch("looking", 1);
        this.assertSearch("\"a\"", 1);
        this.assertSearch("\"description\"", 3);
        this.assertSearch("\"LOOKING\"", 1);
        this.assertSearch("\"TEST\"", 2);
        this.assertSearch("\"testing\"", 1);
        this.assertSearchNoHits("look");
        this.assertSearchNoHits("\"look\"");
    }

    protected void testExactMatchBoost() throws Exception {
        this.addDocument("one two three four five six seven eight");
        this.addDocument("one two three four five six");
        this.addDocument("three four five six seven");
        this.addDocument("one two four five seven eight");
        this.assertSearch("one two four five seven eight", Arrays.asList("one two four five seven eight", "one two three four five six seven eight", "one two three four five six", "three four five six seven"));
        this.assertSearch("three four five six seven", Arrays.asList("three four five six seven", "one two three four five six seven eight", "one two three four five six", "one two four five seven eight"));
        this.assertSearch("\"one two\" \"three four\" \"five six\"", Arrays.asList("one two three four five six", "one two three four five six seven eight"));
        this.assertSearch("\"three four\" five \"six seven\"", Arrays.asList("three four five six seven", "one two three four five six seven eight"));
    }

    protected void testMultiwordPhrasePrefixes() throws Exception {
        this.addDocument("Name Tags");
        this.addDocument("Names Tab");
        this.addDocument("Tag Names");
        this.addDocument("Tabs Names Tags");
        this.assertSearch("\"name ta*\"", 1);
        this.assertSearch("\"name tag*\"", 1);
        this.assertSearch("\"name tags*\"", 1);
        this.assertSearch("\"names ta*\"", 2);
        this.assertSearch("\"names tab*\"", 1);
        this.assertSearch("\"names tag*\"", 1);
        this.assertSearch("\"names tags*\"", 1);
        this.assertSearch("\"tabs name*\"", 1);
        this.assertSearch("\"tabs names ta*\"", 1);
        this.assertSearch("\"tabs names tag*\"", 1);
        this.assertSearch("\"tabs names tags*\"", 1);
        this.assertSearch("\"tabs names*\"", 1);
        this.assertSearch("\"tag na*\"", 1);
        this.assertSearch("\"tag name*\"", 1);
        this.assertSearch("\"tag names*\"", 1);
        this.assertSearchNoHits("\"name tab*\"");
        this.assertSearchNoHits("\"name tabs*\"");
        this.assertSearchNoHits("\"names tabs*\"");
        this.assertSearchNoHits("\"tab na*\"");
        this.assertSearchNoHits("\"tab names*\"");
        this.assertSearchNoHits("\"tabs na ta*\"");
        this.assertSearchNoHits("\"tabs name ta*\"");
        this.assertSearchNoHits("\"tags na ta*\"");
        this.assertSearchNoHits("\"tags names tabs*\"");
        this.assertSearchNoHits("\"tags names*\"");
        this.assertSearchNoHits("\"zz na*\"");
        this.assertSearchNoHits("\"zz name*\"");
        this.assertSearchNoHits("\"zz names*\"");
        this.assertSearchNoHits("\"zz ta*\"");
        this.assertSearchNoHits("\"zz tab*\"");
        this.assertSearchNoHits("\"zz tabs*\"");
        this.assertSearchNoHits("\"zz tag*\"");
        this.assertSearchNoHits("\"zz tags*\"");
    }

    protected void testMultiwordPrefixes() throws Exception {
        this.addDocument("Name Tags");
        this.addDocument("Names Tab");
        this.addDocument("Tag Names");
        this.addDocument("Tabs Names Tags");
        this.assertSearch("name ta", 1);
        this.assertSearch("name tab", 2);
        this.assertSearch("name tabs", 2);
        this.assertSearch("name tag", 2);
        this.assertSearch("name tags", 2);
        this.assertSearch("names ta", 3);
        this.assertSearch("names tab", 3);
        this.assertSearch("names tabs", 3);
        this.assertSearch("names tag", 3);
        this.assertSearch("names tags", 4);
        this.assertSearch("tab na", 1);
        this.assertSearch("tab names", 3);
        this.assertSearch("tabs na ta", 1);
        this.assertSearch("tabs names tags", 4);
        this.assertSearch("tabs names", 3);
        this.assertSearch("tag na", 1);
        this.assertSearch("tag name", 2);
        this.assertSearch("tag names", 3);
        this.assertSearch("tags na ta", 2);
        this.assertSearch("tags names tabs", 4);
        this.assertSearch("tags names", 4);
        this.assertSearch("zz name", 1);
        this.assertSearch("zz names", 3);
        this.assertSearch("zz tab", 1);
        this.assertSearch("zz tabs", 1);
        this.assertSearch("zz tag", 1);
        this.assertSearch("zz tags", 2);
        this.assertSearchNoHits("zz na");
        this.assertSearchNoHits("zz ta");
    }

    protected void testNull() throws Exception {
        this.addDocument("null");
        this.addDocument("anulled");
        this.addDocument("The word null is in this sentence");
        this.addDocument("Ultimate Nullifier");
        this.addDocument("llun");
        this.assertSearch("null", Arrays.asList("null", "The word null is in this sentence"));
    }

    protected void testNumbers() throws Exception {
        this.addDocument("Description with 1 number");
        this.addDocument("Description with NO numbers");
        this.addDocument("4ever");
        this.assertSearch("1", 1);
        this.assertSearch("4ever", 1);
        this.assertSearch("4EVER", 1);
        this.assertSearch("\"1\"", 1);
        this.assertSearch("\"4ever\"", 1);
        this.assertSearch("\"4EVER\"", 1);
        this.assertSearchNoHits("4");
        this.assertSearchNoHits("\"4\"");
        this.assertSearchNoHits("FOREVER");
    }

    protected void testPhrasePrefixes() throws Exception {
        this.addDocument("Nametag");
        this.addDocument("NA-META-G");
        this.addDocument("Tag Name");
        this.addDocument("TAG1");
        this.assertSearch("\"me*\"", 1);
        this.assertSearch("\"meta\"", 1);
        this.assertSearch("\"namet*\"", 1);
        this.assertSearch("\"Ta*\"", 2);
        this.assertSearch("\"tag\"", 1);
        this.assertSearch("\"*me*\"", 1);
        this.assertSearch("\"*met*\"", 1);
        this.assertSearch("\"*namet*\"", 1);
        this.assertSearch("\"*Ta*\"", 2);
        this.assertSearchNoHits("\"met\"");
        this.assertSearchNoHits("\"Namet\"");
        this.assertSearchNoHits("\"Ta\"");
        this.assertSearchNoHits("\"*me\"");
        this.assertSearchNoHits("\"*namet\"");
        this.assertSearchNoHits("\"*Ta\"");
    }

    protected void testPhrasePrefixRequiresTrailingStar() throws Exception {
        this.addDocument("Nametag");
        this.addDocument("NA-META-G");
        this.addDocument("Tag Name");
        this.addDocument("TAG1");
        this.assertSearch("\"NAM*\"", 2);
        this.assertSearch("\"*nam*\"", 2);
        this.assertSearchNoHits("\"Nam\"");
        this.assertSearchNoHits("\"*NAM\"");
    }

    protected void testPhrases() throws Exception {
        this.addDocument("Names of Tags");
        this.addDocument("More names of tags here");
        this.assertSearch("\"HERE\"", 1);
        this.assertSearch("\"more\"   names   \"here\"", 1);
        this.assertSearch("\"More\"", 1);
        this.assertSearch("\"more\"", 1);
        this.assertSearch("\"names of tags\"", 2);
        this.assertSearch("\"NAmes\" \"TAGS\"", 2);
        this.assertSearch("\"names\" MORE \"tags\"", 1);
        this.assertSearch("\"names\" of \"tAgs\"", 2);
        this.assertSearch("\"Tags here\"", 1);
        this.assertSearch("\"Tags\" here", 1);
        this.assertSearch("\"TAGS\"", 2);
        this.assertSearch("\"   more   \"   tags   \"   here   \"", 1);
        this.assertSearchNoHits("\"more\" other \"here\"");
        this.assertSearchNoHits("\"name\" of \"tags\"");
    }

    protected void testStopwords() throws Exception {
        this.addDocument("Names of Tags");
        this.addDocument("More names of tags");
        this.assertSearch("of", 2);
        this.assertSearch("Names of tags", 2);
        this.assertSearch("tags names", 2);
    }

    protected void testWordPrefixes() throws Exception {
        this.addDocument("Nametag");
        this.addDocument("NA-META-G");
        this.addDocument("Tag Name");
        this.addDocument("TAG1");
        this.assertSearch("Na", 1);
        this.assertSearch("NA*", 1);
        this.assertSearch("tag", 1);
        this.assertSearch("*NA", 1);
        this.assertSearch("*NA*", 1);
        this.assertSearchNoHits("me");
        this.assertSearchNoHits("me*");
        this.assertSearchNoHits("met");
        this.assertSearchNoHits("Namet");
        this.assertSearchNoHits("namet*");
        this.assertSearchNoHits("Ta");
        this.assertSearchNoHits("Ta*");
        this.assertSearchNoHits("*me");
        this.assertSearchNoHits("*me*");
        this.assertSearchNoHits("*met*");
        this.assertSearchNoHits("*namet");
        this.assertSearchNoHits("*namet*");
        this.assertSearchNoHits("*Ta");
        this.assertSearchNoHits("*Ta*");
    }
}

