/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.indexing;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import java.text.SimpleDateFormat;
import org.mockito.Mockito;

public class DocumentFixture {
    protected Props props;
    private FastDateFormatFactory _fastDateFormatFactory;
    private Props _props;

    public static Document newDocument(long companyId, long groupId, String entryClassName) {
        DocumentImpl document = new DocumentImpl();
        document.addKeyword("companyId", companyId);
        document.addKeyword("groupId", groupId);
        long entryClassPK = RandomTestUtil.randomLong();
        document.addUID(entryClassName, entryClassPK);
        DocumentHelper documentHelper = new DocumentHelper((Document)document);
        documentHelper.setEntryKey(entryClassName, entryClassPK);
        return document;
    }

    public void mockProperty(String property, String value) {
        Mockito.when((Object)this.props.get(property)).thenReturn((Object)value);
    }

    public void setUp() {
        this.setUpFastDateFormatFactoryUtil();
        this.setUpPropsUtil();
    }

    public void tearDown() {
        this.tearDownFastDateFormatFactoryUtil();
        this.tearDownPropsUtil();
    }

    protected void setUpFastDateFormatFactoryUtil() {
        this._fastDateFormatFactory = FastDateFormatFactoryUtil.getFastDateFormatFactory();
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        FastDateFormatFactory fastDateFormatFactory = (FastDateFormatFactory)Mockito.mock(FastDateFormatFactory.class);
        Mockito.when((Object)fastDateFormatFactory.getSimpleDateFormat("yyyyMMddHHmmss")).thenReturn((Object)new SimpleDateFormat("yyyyMMddHHmmss"));
        fastDateFormatFactoryUtil.setFastDateFormatFactory(fastDateFormatFactory);
    }

    protected void setUpPropsUtil() {
        this._props = PropsUtil.getProps();
        this.props = (Props)Mockito.mock(Props.class);
        this.mockProperty("index.date.format.pattern", "yyyyMMddHHmmss");
        this.mockProperty("index.search.collated.spell.check.result.enabled", "true");
        this.mockProperty("index.search.collated.spell.check.result.scores.threshold", "50");
        this.mockProperty("index.search.highlight.fragment.size", "80");
        this.mockProperty("index.search.highlight.require.field.match", "true");
        this.mockProperty("index.search.highlight.snippet.size", "3");
        this.mockProperty("index.search.query.indexing.enabled", "true");
        this.mockProperty("index.search.query.indexing.threshold", "50");
        this.mockProperty("index.search.query.suggestion.enabled", "true");
        this.mockProperty("index.search.query.suggestion.max", "yyyyMMddHHmmss");
        this.mockProperty("index.search.query.suggestion.scores.threshold", "0");
        this.mockProperty("index.search.scoring.enabled", "true");
        this.mockProperty("index.sortable.text.fields.truncated.length", "255");
        PropsUtil.setProps((Props)this.props);
    }

    protected void tearDownFastDateFormatFactoryUtil() {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory(this._fastDateFormatFactory);
        this._fastDateFormatFactory = null;
    }

    protected void tearDownPropsUtil() {
        PropsUtil.setProps((Props)this._props);
        this._props = null;
        this.props = null;
    }
}

