/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.indexing;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.test.util.SearchMapUtil;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelper;
import com.liferay.portal.search.test.util.indexing.DocumentFixture;
import com.liferay.portal.search.test.util.indexing.IndexingFixture;
import com.liferay.portal.search.test.util.indexing.QueryContributor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;

public abstract class BaseIndexingTestCase {
    protected static final long COMPANY_ID = RandomTestUtil.randomLong();
    protected static final long GROUP_ID = RandomTestUtil.randomLong();
    private final DocumentFixture _documentFixture = new DocumentFixture();
    private final String _entryClassName;
    private IndexingFixture _indexingFixture;
    private IndexSearcher _indexSearcher;
    private IndexWriter _indexWriter;

    public BaseIndexingTestCase() {
        Class<?> clazz = this.getClass();
        this._entryClassName = StringUtil.toLowerCase((String)clazz.getSimpleName());
    }

    @Before
    public void setUp() throws Exception {
        this._documentFixture.setUp();
        this._indexingFixture = this.createIndexingFixture();
        Assume.assumeTrue((boolean)this._indexingFixture.isSearchEngineAvailable());
        this._indexingFixture.setUp();
        this._indexSearcher = this._indexingFixture.getIndexSearcher();
        this._indexWriter = this._indexingFixture.getIndexWriter();
    }

    @After
    public void tearDown() throws Exception {
        if (!this._indexingFixture.isSearchEngineAvailable()) {
            return;
        }
        try {
            this._indexWriter.deleteEntityDocuments(BaseIndexingTestCase.createSearchContext(), this._entryClassName);
        }
        catch (SearchException searchException) {
            // empty catch block
        }
        this._documentFixture.tearDown();
        this._indexingFixture.tearDown();
    }

    protected static SearchContext createSearchContext() {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(COMPANY_ID);
        searchContext.setGroupIds(new long[]{GROUP_ID});
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setHitsProcessingEnabled(true);
        queryConfig.setScoreEnabled(false);
        searchContext.setStart(-1);
        return searchContext;
    }

    protected static <K, V> Map<K, V> toMap(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    protected void addDocument(DocumentCreationHelper documentCreationHelper) throws Exception {
        Document document = DocumentFixture.newDocument(COMPANY_ID, GROUP_ID, this._entryClassName);
        documentCreationHelper.populate(document);
        this._indexWriter.addDocument(BaseIndexingTestCase.createSearchContext(), document);
    }

    protected void addDocuments(Function<String, DocumentCreationHelper> function, Collection<String> values) throws Exception {
        for (String value : values) {
            this.addDocument(function.apply(value));
        }
    }

    protected abstract IndexingFixture createIndexingFixture() throws Exception;

    protected Query getDefaultQuery() throws Exception {
        Map<String, String> map = SearchMapUtil.join(BaseIndexingTestCase.toMap("companyId", String.valueOf(COMPANY_ID)), BaseIndexingTestCase.toMap("entryClassName", this._entryClassName), new Map[0]);
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        map.forEach((key, value) -> booleanQueryImpl.add((Query)new TermQueryImpl(key, value), BooleanClauseOccur.MUST));
        return booleanQueryImpl;
    }

    protected IndexSearcher getIndexSearcher() {
        return this._indexSearcher;
    }

    protected IndexWriter getIndexWriter() {
        return this._indexWriter;
    }

    protected Hits search(SearchContext searchContext) throws Exception {
        return this.search(searchContext, this.getDefaultQuery());
    }

    protected Hits search(SearchContext searchContext, Query query) throws Exception {
        return this._indexSearcher.search(searchContext, query);
    }

    protected Hits search(SearchContext searchContext, QueryContributor queryContributor) throws Exception {
        return this.search(searchContext, this._getQuery(queryContributor));
    }

    private Query _getQuery(QueryContributor queryContributor) throws Exception {
        Query query = this.getDefaultQuery();
        if (queryContributor == null) {
            return query;
        }
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        booleanQuery.add(query, BooleanClauseOccur.MUST);
        queryContributor.contribute((BooleanQuery)booleanQuery);
        return booleanQuery;
    }
}

