/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.highlight;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.StringQuery;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class BaseHighlightTestCase
extends BaseIndexingTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        LocalizationUtil localizationUtil = new LocalizationUtil();
        localizationUtil.setLocalization(this.createLocalization());
    }

    @Test
    public void testEllipsis() throws Exception {
        String fieldName = "title";
        this.addDocuments(value -> DocumentCreationHelpers.singleText(fieldName, value), Arrays.asList("alpha", "alpha beta", "alpha beta alpha", "alpha beta gamma alpha eta theta alpha zeta eta alpha iota", "alpha beta gamma delta epsilon zeta eta theta iota alpha"));
        StringQuery query = new StringQuery(fieldName.concat(":alpha"));
        this.assertSearch(fieldName, (Query)query, queryConfig -> queryConfig.setHighlightFragmentSize(20), this.toFullHighlights("[H]alpha[/H]", "[H]alpha[/H] beta", "[H]alpha[/H] beta [H]alpha[/H]", "[H]alpha[/H] beta gamma...[H]alpha[/H] eta theta [H]alpha[/H]...zeta eta [H]alpha[/H] iota", "[H]alpha[/H] beta gamma...theta iota [H]alpha[/H]"));
    }

    protected void assertSearch(String fieldName, Query query, Consumer<QueryConfig> consumer, List<String> expectedValues) throws Exception {
        IdempotentRetryAssert.retryAssert(5L, TimeUnit.SECONDS, () -> this.doAssertSearch(fieldName, query, consumer, expectedValues));
    }

    protected Localization createLocalization() {
        Localization localization = (Localization)Mockito.mock(Localization.class);
        ((Localization)Mockito.doReturn((Object)"").when((Object)localization)).getLocalizedName(Mockito.anyString(), Mockito.anyString());
        return localization;
    }

    protected Void doAssertSearch(String fieldName, Query query, Consumer<QueryConfig> consumer, List<String> expectedValues) throws Exception {
        SearchContext searchContext = BaseHighlightTestCase.createSearchContext();
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.addHighlightFieldNames(new String[]{fieldName});
        queryConfig.addSelectedFieldNames(new String[]{fieldName});
        queryConfig.setHighlightEnabled(true);
        queryConfig.setHighlightRequireFieldMatch(true);
        consumer.accept(queryConfig);
        query.setQueryConfig(queryConfig);
        Hits hits = this.search(searchContext, query);
        String snippetFieldName = "snippet_".concat(fieldName);
        DocumentsAssert.assertValuesIgnoreRelevance((String)((Object)searchContext.getAttribute("queryString")), hits.getDocs(), snippetFieldName, expectedValues);
        return null;
    }

    protected String toFullHighlight(String s) {
        return StringUtil.replace((String)s, (String[])new String[]{"[H]", "[/H]"}, (String[])new String[]{"<liferay-hl>", "</liferay-hl>"});
    }

    protected List<String> toFullHighlights(String ... strings) {
        return Stream.of(strings).map(this::toFullHighlight).collect(Collectors.toList());
    }
}

