/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.groupby;

import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public abstract class BaseGroupByTestCase
extends BaseIndexingTestCase {
    protected static final String GROUP_FIELD = "userName";

    protected void addDocuments(String name, int count) throws Exception {
        String field = GROUP_FIELD;
        for (int i = 1; i <= count; ++i) {
            this.addDocument(DocumentCreationHelpers.singleKeyword(GROUP_FIELD, name));
        }
    }

    protected void assertGroup(String key, int hitsCount, int docsCount, Map<String, Hits> groupedHitsMap) {
        Hits hits = groupedHitsMap.get(key);
        Assert.assertNotNull((Object)hits);
        Assert.assertEquals((String)hits.toString(), (long)hitsCount, (long)hits.getLength());
        Object[] docs = hits.getDocs();
        Assert.assertEquals((String)Arrays.toString(docs), (long)docsCount, (long)docs.length);
    }

    protected void assertGroup(String key, int count, Map<String, Hits> groupedHitsMap) {
        this.assertGroup(key, count, count, groupedHitsMap);
    }

    protected Map<String, Hits> searchGroups(SearchContext searchContext) throws Exception {
        Hits hits = this.search(searchContext);
        Map groupedHitsMap = hits.getGroupedHits();
        Assert.assertNotNull((Object)groupedHitsMap);
        return groupedHitsMap;
    }

    protected void testGroupBy() throws Exception {
        this.addDocuments("sixteen", 16);
        this.addDocuments("three", 3);
        this.addDocuments("two", 2);
        final SearchContext searchContext = BaseGroupByTestCase.createSearchContext();
        searchContext.setGroupBy(new GroupBy(GROUP_FIELD));
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Map<String, Hits> groupedHitsMap = BaseGroupByTestCase.this.searchGroups(searchContext);
                Assert.assertEquals((String)groupedHitsMap.toString(), (long)3L, (long)groupedHitsMap.size());
                BaseGroupByTestCase.this.assertGroup("sixteen", 16, groupedHitsMap);
                BaseGroupByTestCase.this.assertGroup("three", 3, groupedHitsMap);
                BaseGroupByTestCase.this.assertGroup("two", 2, groupedHitsMap);
                return null;
            }
        });
    }

    protected void testStartAndEnd() throws Exception {
        this.addDocuments("sixteen", 16);
        final SearchContext searchContext = BaseGroupByTestCase.createSearchContext();
        searchContext.setEnd(9);
        searchContext.setGroupBy(new GroupBy(GROUP_FIELD));
        searchContext.setStart(4);
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Map<String, Hits> groupedHitsMap = BaseGroupByTestCase.this.searchGroups(searchContext);
                BaseGroupByTestCase.this.assertGroup("sixteen", 16, 6, groupedHitsMap);
                return null;
            }
        });
    }

    protected void testStartAndSize() throws Exception {
        this.addDocuments("sixteen", 16);
        final SearchContext searchContext = BaseGroupByTestCase.createSearchContext();
        GroupBy groupBy = new GroupBy(GROUP_FIELD);
        groupBy.setSize(3);
        groupBy.setStart(8);
        searchContext.setGroupBy(groupBy);
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Map<String, Hits> groupedHitsMap = BaseGroupByTestCase.this.searchGroups(searchContext);
                BaseGroupByTestCase.this.assertGroup("sixteen", 16, 3, groupedHitsMap);
                return null;
            }
        });
    }
}

