/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.filter;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public abstract class BaseTermsFilterTestCase
extends BaseIndexingTestCase {
    @Test
    public void testKeywordField() throws Exception {
        String fieldName = "folderId";
        this.addDocuments(value -> DocumentCreationHelpers.singleKeyword(fieldName, value), Arrays.asList("One", "Two", "Three"));
        TermsFilter termsFilter = new TermsFilter(fieldName);
        termsFilter.addValues(new String[]{"Two", "Three"});
        this.assertSearch((Filter)termsFilter, fieldName, Arrays.asList("Two", "Three"));
    }

    protected void assertSearch(Filter filter, String fieldName, List<String> expectedValues) throws Exception {
        IdempotentRetryAssert.retryAssert(10L, TimeUnit.SECONDS, () -> this.doAssertSearch(filter, fieldName, expectedValues));
    }

    protected Void doAssertSearch(Filter filter, String fieldName, List<String> expectedValues) throws Exception {
        SearchContext searchContext = BaseTermsFilterTestCase.createSearchContext();
        Hits hits = this.search(searchContext, (BooleanQuery booleanQuery) -> this.setPreBooleanFilter(filter, (Query)booleanQuery));
        DocumentsAssert.assertValues((String)((Object)searchContext.getAttribute("queryString")), hits.getDocs(), fieldName, expectedValues);
        return null;
    }

    protected void setPreBooleanFilter(Filter filter, Query query) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add(filter, BooleanClauseOccur.MUST);
        query.setPreBooleanFilter(booleanFilter);
    }
}

