/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.MultiValueFacet;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.test.util.facet.BaseFacetTestCase;
import java.io.Serializable;
import java.util.Arrays;
import org.junit.Test;

public abstract class BaseMultiValueFacetTestCase
extends BaseFacetTestCase {
    @Test
    public void testSelection() throws Exception {
        this.addDocuments(6, "one");
        this.addDocuments(5, "two");
        this.addDocuments(4, "three");
        this.addDocuments(3, "four");
        this.addDocuments(2, "five");
        this.assertSearch(helper -> {
            MultiValueFacet multiValueFacet = helper.addFacet(this::createFacet);
            this.select(multiValueFacet, (BaseFacetTestCase.Helper)helper, "three", "one");
            helper.search();
            helper.assertResultCount(10);
            helper.assertFrequencies((Facet)multiValueFacet, Arrays.asList("one=6", "two=5", "three=4", "four=3", "five=2"));
        });
    }

    protected MultiValueFacet createFacet(SearchContext searchContext) {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        this.initFacet((Facet)multiValueFacet);
        multiValueFacet.setFieldName("status");
        return multiValueFacet;
    }

    @Override
    protected String getField() {
        return "status";
    }

    protected void select(MultiValueFacet multiValueFacet, BaseFacetTestCase.Helper helper, String ... values) {
        JSONArray jsonArray = this.jsonFactory.createJSONArray();
        for (String value : values) {
            jsonArray.put(value);
        }
        multiValueFacet.setValues(jsonArray);
        helper.setSearchContextAttribute(multiValueFacet.getFieldId(), (Serializable)((Object)StringUtil.merge((Object[])values)));
    }
}

