/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet;

import com.liferay.portal.json.JSONFactoryImpl;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.search.test.util.FacetsAssert;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import com.liferay.portal.search.test.util.indexing.QueryContributor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Assert;

public abstract class BaseFacetTestCase
extends BaseIndexingTestCase {
    protected final JSONFactory jsonFactory = new JSONFactoryImpl();

    protected void addDocument(String ... values) throws Exception {
        this.addDocument(DocumentCreationHelpers.singleText(this.getField(), values));
    }

    protected void addDocuments(int count, String ... values) throws Exception {
        for (int i = 0; i < count; ++i) {
            this.addDocument(values);
        }
    }

    protected void assertSearch(Consumer<Helper> consumer) throws Exception {
        IdempotentRetryAssert.retryAssert(5L, TimeUnit.SECONDS, () -> {
            consumer.accept(new Helper());
            return null;
        });
    }

    protected Hits doSearch(SearchContext searchContext) {
        try {
            return this.search(searchContext);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Hits doSearch(SearchContext searchContext, QueryContributor queryContributor) {
        try {
            return this.search(searchContext, queryContributor);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract String getField();

    protected Facet initFacet(Facet facet) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        facetConfiguration.setDataJSONObject(this.jsonFactory.createJSONObject());
        return facet;
    }

    static /* synthetic */ SearchContext access$000() {
        return BaseFacetTestCase.createSearchContext();
    }

    protected class Helper {
        private Hits _hits;
        private final SearchContext _searchContext = BaseFacetTestCase.access$000();

        public <T extends Facet> T addFacet(Function<SearchContext, ? extends T> function) {
            Facet facet = (Facet)function.apply(this._searchContext);
            this._searchContext.addFacet(facet);
            return (T)facet;
        }

        public void assertFrequencies(Facet facet, List<String> expected) {
            FacetsAssert.assertFrequencies(facet.getFieldName(), this._searchContext, expected);
        }

        public void assertResultCount(int expected) {
            Object[] documents = this._hits.getDocs();
            Assert.assertEquals((String)Arrays.toString(documents), (long)expected, (long)documents.length);
        }

        public void search() {
            this._hits = BaseFacetTestCase.this.doSearch(this._searchContext);
        }

        public void search(QueryContributor queryContributor) {
            this._hits = BaseFacetTestCase.this.doSearch(this._searchContext, queryContributor);
        }

        public void setSearchContextAttribute(String name, Serializable value) {
            this._searchContext.setAttribute(name, value);
        }
    }
}

