/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet;

import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.search.facet.tag.AssetTagNamesFacetFactory;
import com.liferay.portal.search.internal.facet.tag.AssetTagNamesFacetFactoryImpl;
import com.liferay.portal.search.test.util.facet.BaseFacetTestCase;
import com.liferay.portal.search.test.util.indexing.QueryContributors;
import java.util.Arrays;
import org.junit.Test;

public abstract class BaseAssetTagNamesFacetTestCase
extends BaseFacetTestCase {
    protected AssetTagNamesFacetFactory assetTagNamesFacetFactory = new AssetTagNamesFacetFactoryImpl();

    @Test
    public void testCaseInsensitiveSearchCaseSensitiveGrouping() throws Exception {
        this.addDocument("tag");
        this.addDocument("tAg");
        this.addDocument("TAG");
        this.addDocument(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]));
        this.assertSearch(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            helper.search(QueryContributors.mustMatch(this.getField(), "tag"));
            helper.assertFrequencies(facet, Arrays.asList("TAG=1", "tAg=1", "tag=1"));
        });
    }

    @Test
    public void testKeysWithSpaces() throws Exception {
        this.addDocument("Green-Blue Tag");
        this.addDocument("Green-Blue Tag", "Red Tag");
        this.addDocument("Tag");
        this.assertSearch(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            helper.search();
            helper.assertFrequencies(facet, Arrays.asList("Green-Blue Tag=2", "Red Tag=1", "Tag=1"));
        });
    }

    protected Facet createFacet(SearchContext searchContext) {
        return this.initFacet((Facet)this.assetTagNamesFacetFactory.newInstance(searchContext));
    }

    @Override
    protected String getField() {
        return "assetTagNames";
    }
}

