/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.count;

import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.UniqueStringRandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseCountTestCase
extends BaseIndexingTestCase {
    private static final int _TOTAL_DOCUMENTS = 20;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        for (int i = 0; i < 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleText("test-field", RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[]{UniqueStringRandomizerBumper.INSTANCE})));
        }
    }

    @Test
    public void testAll() throws Exception {
        this._assertCount(BaseCountTestCase.createSearchContext());
    }

    @Test
    public void testPaginationIsIgnored() throws Exception {
        SearchContext searchContext = BaseCountTestCase.createSearchContext();
        int start = 5;
        searchContext.setEnd(start - 1);
        searchContext.setStart(start);
        this._assertCount(searchContext);
    }

    @Test
    public void testPostFilterWithoutMainQuery() throws Exception {
        BooleanQueryImpl query = new BooleanQueryImpl();
        query.setPostFilter((Filter)this._createBooleanFilter());
        this._assertCount((Query)query, BaseCountTestCase.createSearchContext());
    }

    @Test
    public void testPreFilterWithoutMainQuery() throws Exception {
        BooleanQueryImpl query = new BooleanQueryImpl();
        query.setPreBooleanFilter(this._createBooleanFilter());
        this._assertCount((Query)query, BaseCountTestCase.createSearchContext());
    }

    private void _assertCount(Query query, SearchContext searchContext) throws Exception {
        IdempotentRetryAssert.retryAssert(3L, TimeUnit.SECONDS, () -> {
            IndexSearcher indexSearcher = this.getIndexSearcher();
            long count = indexSearcher.searchCount(searchContext, query);
            Assert.assertEquals((long)20L, (long)count);
            return null;
        });
    }

    private void _assertCount(SearchContext searchContext) throws Exception {
        Query query = this.getDefaultQuery();
        this._assertCount(query, searchContext);
    }

    private BooleanFilter _createBooleanFilter() {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.addRequiredTerm("groupId", GROUP_ID);
        return booleanFilter;
    }
}

