/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class IdempotentRetryAssert {
    public static <T> T retryAssert(long timeout, TimeUnit timeoutTimeUnit, Callable<T> callable) throws Exception {
        return IdempotentRetryAssert.retryAssert(timeout, timeoutTimeUnit, 0L, TimeUnit.SECONDS, callable);
    }

    public static <T> T retryAssert(long timeout, TimeUnit timeoutTimeUnit, long pause, TimeUnit pauseTimeUnit, Callable<T> callable) throws Exception {
        long deadline = System.currentTimeMillis() + timeoutTimeUnit.toMillis(timeout);
        while (true) {
            try {
                return callable.call();
            }
            catch (AssertionError ae) {
                if (System.currentTimeMillis() > deadline) {
                    throw ae;
                }
                Thread.sleep(pauseTimeUnit.toMillis(pause));
                continue;
            }
            break;
        }
    }
}

