/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.search.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;

public class DocumentsAssert {
    public static void assertCount(String message, Document[] documents, String field, int expectedCount) {
        if (documents.length == expectedCount) {
            return;
        }
        List<String> actualValues = DocumentsAssert._getValues(field, documents);
        Assert.assertEquals((String)(message + "->" + actualValues), (long)expectedCount, (long)documents.length);
    }

    public static void assertValues(String message, Document[] documents, String field, List<String> expectedValues) {
        List<String> actualValues = DocumentsAssert._getValues(field, documents);
        Assert.assertEquals((String)(message + "->" + actualValues), (Object)expectedValues.toString(), (Object)actualValues.toString());
    }

    public static void assertValuesIgnoreRelevance(String message, Document[] documents, String field, Collection<String> expectedValues) {
        List<String> actualValues = DocumentsAssert._getValues(field, documents);
        Assert.assertEquals((String)(message + "->" + actualValues), (Object)DocumentsAssert._sort(expectedValues), (Object)DocumentsAssert._sort(actualValues));
    }

    private static List<String> _getValues(String field, Document ... documents) {
        return Stream.of(documents).map(document -> document.get(field)).collect(Collectors.toList());
    }

    private static String _sort(Collection<String> collection) {
        ArrayList<String> list = new ArrayList<String>(collection);
        Collections.sort(list);
        return ((Object)list).toString();
    }
}

