/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.IdentityServiceContextFunction;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.SearchContextTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.test.randomizerbumpers.BBCodeRandomizerBumper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseSearchTestCase {
    protected static final boolean CHECK_BASE_MODEL_PERMISSION = true;
    protected BaseModel<?> baseModel;
    @DeleteAfterTestRun
    protected Group group;

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
    }

    @Test
    public void testBaseModelUserPermissions() throws Exception {
        this.testUserPermissions(false, true);
    }

    @Test
    public void testLocalizedSearch() throws Exception {
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        int initialBaseModelsSearchCount = 0;
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        HashMap<Locale, String> keywordsMap = new HashMap<Locale, String>();
        keywordsMap.put(LocaleUtil.getDefault(), "entity title");
        keywordsMap.put(LocaleUtil.HUNGARY, "entitas neve");
        this.baseModel = this.addBaseModelWithWorkflow(parentBaseModel, true, keywordsMap, serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        searchContext.setAttribute("title", (Serializable)((Object)"nev"));
        searchContext.setKeywords("nev");
        searchContext.setLocale(LocaleUtil.HUNGARY);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
    }

    @Test
    public void testParentBaseModelUserPermissions() throws Exception {
        this.testUserPermissions(true, false);
    }

    @Test
    public void testSearchAttachments() throws Exception {
        this.searchAttachments();
    }

    @Test
    public void testSearchBaseModel() throws Exception {
        this.searchBaseModel();
    }

    @Test
    public void testSearchBaseModelWithDelete() throws Exception {
        this.searchBaseModelWithDelete();
    }

    @Test
    public void testSearchBaseModelWithTrash() throws Exception {
        this.searchBaseModelWithTrash();
    }

    @Test
    public void testSearchBaseModelWithUpdate() throws Exception {
        this.searchBaseModelWithUpdate();
    }

    @Test
    public void testSearchByDDMStructureField() throws Exception {
        this.searchByDDMStructureField();
    }

    @Test
    public void testSearchByKeywords() throws Exception {
        this.searchByKeywords();
    }

    @Test
    public void testSearchByKeywordsInsideParentBaseModel() throws Exception {
        this.searchByKeywordsInsideParentBaseModel();
    }

    @Test
    public void testSearchComments() throws Exception {
        this.searchComments();
    }

    @Test
    public void testSearchExpireAllVersions() throws Exception {
        this.searchExpireVersions(false);
    }

    @Test
    public void testSearchExpireLatestVersion() throws Exception {
        this.searchExpireVersions(true);
    }

    @Test
    public void testSearchMixedPhraseKeywords() throws Exception {
        this.searchByMixedPhraseKeywords();
    }

    @Test
    public void testSearchMyEntries() throws Exception {
        this.searchMyEntries();
    }

    @Test
    public void testSearchRecentEntries() throws Exception {
        this.searchRecentEntries();
    }

    @Test
    public void testSearchStatus() throws Exception {
        this.searchStatus();
    }

    @Test
    public void testSearchVersions() throws Exception {
        this.searchVersions();
    }

    @Test
    public void testSearchWithinDDMStructure() throws Exception {
        this.searchWithinDDMStructure();
    }

    protected void addAttachment(ClassedModel classedModel) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseModel<?> addBaseModel(BaseModel<?> parentBaseModel, boolean approved, String keywords, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            BaseModel<?> baseModel;
            WorkflowThreadLocal.setEnabled((boolean)true);
            BaseModel<?> baseModel2 = baseModel = this.addBaseModelWithWorkflow(parentBaseModel, approved, keywords, serviceContext);
            return baseModel2;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    protected BaseModel<?> addBaseModelWithDDMStructure(BaseModel<?> parentBaseModel, String keywords, ServiceContext serviceContext) throws Exception {
        return this.addBaseModel(parentBaseModel, true, keywords, serviceContext);
    }

    protected BaseModel<?> addBaseModelWithWorkflow(BaseModel<?> parentBaseModel, boolean approved, Map<Locale, String> keywordsMap, ServiceContext serviceContext) throws Exception {
        return this.addBaseModelWithWorkflow(parentBaseModel, approved, keywordsMap.get(LocaleUtil.getDefault()), serviceContext);
    }

    protected abstract BaseModel<?> addBaseModelWithWorkflow(BaseModel<?> var1, boolean var2, String var3, ServiceContext var4) throws Exception;

    protected void addComment(ClassedModel classedModel, String body, ServiceContext serviceContext) throws Exception {
        User user = TestPropsValues.getUser();
        CommentManagerUtil.addComment((long)user.getUserId(), (long)serviceContext.getScopeGroupId(), (String)this.getBaseModelClassName(), (long)this.getBaseModelClassPK(classedModel), (String)body, (Function)new IdentityServiceContextFunction(serviceContext));
    }

    protected void assertBaseModelsCount(int expectedCount, SearchContext searchContext) throws Exception {
        Hits hits = this.searchBaseModelsCount(searchContext);
        Assert.assertEquals((String)(searchContext.getAttribute("queryString") + "->" + hits), (long)expectedCount, (long)hits.getLength());
    }

    protected void assertBaseModelsCount(int expectedCount, String keywords, SearchContext searchContext) throws Exception {
        searchContext.setKeywords(keywords);
        this.assertBaseModelsCount(expectedCount, searchContext);
    }

    protected void assertGroupEntriesCount(long expectedCount) throws Exception {
        this.assertGroupEntriesCount(expectedCount, 0L);
    }

    protected void assertGroupEntriesCount(long expectedCount, long userId) throws Exception {
        Hits hits = this.searchGroupEntries(this.group.getGroupId(), userId);
        Assert.assertEquals((String)hits.toString(), (long)expectedCount, (long)hits.getLength());
    }

    protected void assertGroupEntriesCount(long expectedCount, User user) throws Exception {
        this.assertGroupEntriesCount(expectedCount, user.getUserId());
    }

    protected void deleteBaseModel(BaseModel<?> baseModel) throws Exception {
        this.deleteBaseModel((Long)baseModel.getPrimaryKeyObj());
    }

    protected void deleteBaseModel(long primaryKey) throws Exception {
    }

    protected void expireBaseModelVersions(BaseModel<?> baseModel, boolean expireAllVersions, ServiceContext serviceContext) throws Exception {
    }

    protected abstract Class<?> getBaseModelClass();

    protected String getBaseModelClassName() {
        Class<?> clazz = this.getBaseModelClass();
        return clazz.getName();
    }

    protected Long getBaseModelClassPK(ClassedModel classedModel) {
        return (Long)classedModel.getPrimaryKeyObj();
    }

    protected String getDDMStructureFieldName() {
        return "";
    }

    protected BaseModel<?> getParentBaseModel(BaseModel<?> parentBaseModel, ServiceContext serviceContext) throws Exception {
        return parentBaseModel;
    }

    protected BaseModel<?> getParentBaseModel(Group group, ServiceContext serviceContext) throws Exception {
        return group;
    }

    protected String getParentBaseModelClassName() {
        return "";
    }

    protected abstract String getSearchKeywords();

    protected boolean isCheckBaseModelPermission() {
        return true;
    }

    protected boolean isExpirableAllVersions() {
        return false;
    }

    protected void moveBaseModelToTrash(long primaryKey) throws Exception {
    }

    protected void moveParentBaseModelToTrash(long primaryKey) throws Exception {
    }

    protected void searchAttachments() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setIncludeAttachments(true);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsSearchCount = 0;
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        this.baseModel = this.addBaseModel(parentBaseModel, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        this.addAttachment((ClassedModel)this.baseModel);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 2, searchContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
    }

    protected void searchBaseModel() throws Exception {
        this.searchBaseModel(0);
    }

    protected void searchBaseModel(int initialBaseModelsSearchCount) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        this.baseModel = this.addBaseModel(parentBaseModel, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
    }

    protected Hits searchBaseModelsCount(Class<?> clazz, long groupId, SearchContext searchContext) throws Exception {
        Indexer indexer = IndexerRegistryUtil.getIndexer(clazz);
        searchContext.setGroupIds(new long[]{groupId});
        return indexer.search(searchContext);
    }

    protected Hits searchBaseModelsCount(SearchContext searchContext) throws Exception {
        return this.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId(), searchContext);
    }

    protected void searchBaseModelWithDelete() throws Exception {
        this.searchBaseModelWithDelete(0);
    }

    protected void searchBaseModelWithDelete(int initialBaseModelsSearchCount) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        this.baseModel = this.addBaseModel(parentBaseModel, true, this.getSearchKeywords(), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        this.deleteBaseModel(this.baseModel);
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
    }

    protected void searchBaseModelWithTrash() throws Exception {
        this.searchBaseModelWithTrash(0);
    }

    protected void searchBaseModelWithTrash(int initialBaseModelsSearchCount) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        this.baseModel = this.addBaseModel(parentBaseModel, true, this.getSearchKeywords(), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        searchContext.setKeywords(this.getSearchKeywords());
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
    }

    protected void searchBaseModelWithUpdate() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        searchContext.setKeywords(this.getSearchKeywords());
        int initialBaseModelsSearchCount = 0;
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        this.baseModel = this.addBaseModel(parentBaseModel, true, this.getSearchKeywords(), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        String updatedKeywords = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[]{BBCodeRandomizerBumper.INSTANCE});
        this.baseModel = this.updateBaseModel(this.baseModel, updatedKeywords, serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        searchContext.setKeywords(updatedKeywords);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
    }

    protected void searchByDDMStructureField() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        int initialBaseModelsSearchCount = 0;
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModelWithDDMStructure(parentBaseModel, this.getSearchKeywords(), serviceContext);
        searchContext.setAttribute("ddmStructureFieldName", (Serializable)((Object)this.getDDMStructureFieldName()));
        searchContext.setAttribute("ddmStructureFieldValue", (Serializable)((Object)this.getSearchKeywords()));
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        this.updateDDMStructure(serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
    }

    protected void searchByKeywords() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setKeywords(this.getSearchKeywords());
        int initialBaseModelsSearchCount = 0;
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, true, this.getSearchKeywords(), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
    }

    protected void searchByKeywordsInsideParentBaseModel() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        this.baseModel = this.addBaseModel(null, true, this.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel1 = this.getParentBaseModel(this.group, serviceContext);
        searchContext.setFolderIds(new long[]{(Long)parentBaseModel1.getPrimaryKeyObj()});
        searchContext.setKeywords(this.getSearchKeywords());
        int initialBaseModelsSearchCount = 0;
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        this.baseModel = this.addBaseModel(parentBaseModel1, true, this.getSearchKeywords(), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        BaseModel<?> parentBaseModel2 = this.getParentBaseModel(parentBaseModel1, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel2, true, this.getSearchKeywords(), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 2, searchContext);
    }

    protected void searchByMixedPhraseKeywords() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        String keyword1 = this.getSearchKeywords() + 1;
        String keyword2 = this.getSearchKeywords() + 2;
        String keyword3 = this.getSearchKeywords() + 3;
        String keyword4 = this.getSearchKeywords() + 4;
        String keyword5 = this.getSearchKeywords() + 5;
        String keyword6 = this.getSearchKeywords() + 6;
        String keyword7 = this.getSearchKeywords() + 7;
        String combinedKeywords = keyword1 + " " + keyword2 + " " + keyword3 + " " + keyword4 + " " + keyword5 + " " + keyword6 + " " + keyword7;
        searchContext.setKeywords(combinedKeywords);
        int initialBaseModelsSearchCount = 0;
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, true, combinedKeywords, serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setKeywords("\"" + keyword1 + " " + keyword2 + "\"");
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setKeywords("\"" + keyword2 + " " + keyword1 + "\"");
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setKeywords("\"" + keyword2 + " " + keyword4 + "\"");
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setKeywords(keyword1 + " \"" + keyword2 + " " + keyword3 + "\"");
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setKeywords(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]) + " \"" + keyword2 + " " + keyword3 + "\" " + keyword5);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        searchContext.setKeywords(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]) + " \"" + keyword2 + " " + keyword5 + "\" " + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]));
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
    }

    protected void searchComments() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setIncludeDiscussions(true);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsSearchCount = 0;
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        this.baseModel = this.addBaseModel(parentBaseModel, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
        this.addComment((ClassedModel)this.baseModel, this.getSearchKeywords(), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 2, searchContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
    }

    protected void searchExpireVersions(boolean expireAllVersions) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setKeywords(this.getSearchKeywords());
        int initialBaseModelsCount = 0;
        this.assertBaseModelsCount(initialBaseModelsCount, searchContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, true, this.getSearchKeywords(), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsCount + 1, searchContext);
        this.baseModel = this.updateBaseModel(this.baseModel, "liferay", serviceContext);
        this.assertBaseModelsCount(initialBaseModelsCount, searchContext);
        this.expireBaseModelVersions(this.baseModel, expireAllVersions, serviceContext);
        if (expireAllVersions && this.isExpirableAllVersions()) {
            this.assertBaseModelsCount(initialBaseModelsCount, searchContext);
        } else {
            this.assertBaseModelsCount(initialBaseModelsCount + 1, searchContext);
        }
    }

    protected Hits searchGroupEntries(long groupId, long userId) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void searchMyEntries() throws Exception {
        User user1 = UserTestUtil.addUser(null, (long[])new long[]{0L});
        long initialUser1SearchGroupEntriesCount = 0L;
        this.assertGroupEntriesCount(initialUser1SearchGroupEntriesCount, user1);
        User user2 = UserTestUtil.addUser(null, (long[])new long[]{0L});
        long initialUser2SearchGroupEntriesCount = 0L;
        this.assertGroupEntriesCount(initialUser2SearchGroupEntriesCount, user2);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel1 = this.getParentBaseModel(this.group, serviceContext);
        BaseModel<?> parentBaseModel2 = this.getParentBaseModel(this.group, serviceContext);
        String name = PrincipalThreadLocal.getName();
        long userId = serviceContext.getUserId();
        try {
            PrincipalThreadLocal.setName((long)user1.getUserId());
            serviceContext.setUserId(user1.getUserId());
            this.baseModel = this.addBaseModel(parentBaseModel1, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
            this.baseModel = this.addBaseModel(parentBaseModel1, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
            this.baseModel = this.addBaseModel(parentBaseModel2, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
            PrincipalThreadLocal.setName((long)user2.getUserId());
            serviceContext.setUserId(user2.getUserId());
            this.baseModel = this.addBaseModel(parentBaseModel1, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
            this.baseModel = this.addBaseModel(parentBaseModel2, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
        }
        finally {
            PrincipalThreadLocal.setName((String)name);
            serviceContext.setUserId(userId);
        }
        this.assertGroupEntriesCount(initialUser1SearchGroupEntriesCount + 3L, user1);
        this.assertGroupEntriesCount(initialUser2SearchGroupEntriesCount + 2L, user2);
        this.moveParentBaseModelToTrash((Long)parentBaseModel2.getPrimaryKeyObj());
        this.assertGroupEntriesCount(initialUser1SearchGroupEntriesCount + 2L, user1);
        this.assertGroupEntriesCount(initialUser2SearchGroupEntriesCount + 1L, user2);
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getParentBaseModelClassName());
        parentTrashHandler.restoreTrashEntry(user1.getUserId(), ((Long)parentBaseModel2.getPrimaryKeyObj()).longValue());
        this.assertGroupEntriesCount(initialUser1SearchGroupEntriesCount + 3L, user1);
        this.assertGroupEntriesCount(initialUser2SearchGroupEntriesCount + 2L, user2);
        UserLocalServiceUtil.deleteUser((User)user1);
        UserLocalServiceUtil.deleteUser((User)user2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void searchRecentEntries() throws Exception {
        long initialSearchGroupEntriesCount = 0L;
        this.assertGroupEntriesCount(initialSearchGroupEntriesCount);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel1 = this.getParentBaseModel(this.group, serviceContext);
        BaseModel<?> parentBaseModel2 = this.getParentBaseModel(this.group, serviceContext);
        String name = PrincipalThreadLocal.getName();
        try {
            User user1 = UserTestUtil.addUser(null, (long[])new long[]{0L});
            PrincipalThreadLocal.setName((long)user1.getUserId());
            this.baseModel = this.addBaseModel(parentBaseModel1, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
            this.baseModel = this.addBaseModel(parentBaseModel1, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
            this.baseModel = this.addBaseModel(parentBaseModel2, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
            User user2 = UserTestUtil.addUser(null, (long[])new long[]{0L});
            PrincipalThreadLocal.setName((long)user2.getUserId());
            this.baseModel = this.addBaseModel(parentBaseModel1, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
            this.baseModel = this.addBaseModel(parentBaseModel2, true, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
            UserLocalServiceUtil.deleteUser((User)user1);
            UserLocalServiceUtil.deleteUser((User)user2);
        }
        finally {
            PrincipalThreadLocal.setName((String)name);
        }
        this.assertGroupEntriesCount(initialSearchGroupEntriesCount + 5L);
        this.moveParentBaseModelToTrash((Long)parentBaseModel2.getPrimaryKeyObj());
        this.assertGroupEntriesCount(initialSearchGroupEntriesCount + 3L);
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getParentBaseModelClassName());
        parentTrashHandler.restoreTrashEntry(TestPropsValues.getUserId(), ((Long)parentBaseModel2.getPrimaryKeyObj()).longValue());
        this.assertGroupEntriesCount(initialSearchGroupEntriesCount + 5L);
    }

    protected void searchStatus() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        int initialBaseModelsCount = 0;
        this.assertBaseModelsCount(initialBaseModelsCount, "1.0", searchContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, false, "Version 1.0", serviceContext);
        this.assertBaseModelsCount(initialBaseModelsCount, searchContext);
        serviceContext.setWorkflowAction(1);
        this.baseModel = this.updateBaseModel(this.baseModel, "Version 1.1", serviceContext);
        this.assertBaseModelsCount(initialBaseModelsCount, "1.0", searchContext);
        this.assertBaseModelsCount(initialBaseModelsCount + 1, "1.1", searchContext);
        serviceContext.setWorkflowAction(2);
        this.baseModel = this.updateBaseModel(this.baseModel, "Version 1.2", serviceContext);
        this.assertBaseModelsCount(initialBaseModelsCount + 1, "1.1", searchContext);
        this.assertBaseModelsCount(initialBaseModelsCount, "1.2", searchContext);
        serviceContext.setWorkflowAction(1);
        this.baseModel = this.updateBaseModel(this.baseModel, "Version 1.3", serviceContext);
        this.assertBaseModelsCount(initialBaseModelsCount, "1.2", searchContext);
        this.assertBaseModelsCount(initialBaseModelsCount + 1, "1.3", searchContext);
    }

    protected void searchVersions() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setKeywords(this.getSearchKeywords());
        int initialBaseModelsCount = 0;
        this.assertBaseModelsCount(initialBaseModelsCount, searchContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, true, this.getSearchKeywords(), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsCount + 1, searchContext);
        this.baseModel = this.updateBaseModel(this.baseModel, "liferay", serviceContext);
        this.assertBaseModelsCount(initialBaseModelsCount, searchContext);
        this.baseModel = this.updateBaseModel(this.baseModel, "portal", serviceContext);
        searchContext.setKeywords("portal");
        this.assertBaseModelsCount(initialBaseModelsCount + 1, searchContext);
    }

    protected void searchWithinDDMStructure() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setKeywords(this.getSearchKeywords());
        int initialBaseModelsSearchCount = 0;
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModelWithDDMStructure(parentBaseModel, this.getSearchKeywords(), serviceContext);
        this.assertBaseModelsCount(initialBaseModelsSearchCount + 1, searchContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testUserPermissions(boolean addBaseModelPermission, boolean addParentBaseModelPermission) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        SearchContext searchContext = SearchContextTestUtil.getSearchContext((long)this.group.getGroupId());
        searchContext.setKeywords(this.getSearchKeywords());
        int initialBaseModelsSearchCount = 0;
        this.assertBaseModelsCount(initialBaseModelsSearchCount, searchContext);
        serviceContext.setAddGroupPermissions(addParentBaseModelPermission);
        serviceContext.setAddGuestPermissions(addParentBaseModelPermission);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        serviceContext.setAddGroupPermissions(addBaseModelPermission);
        serviceContext.setAddGuestPermissions(addBaseModelPermission);
        this.baseModel = this.addBaseModel(parentBaseModel, true, this.getSearchKeywords(), serviceContext);
        User user = UserTestUtil.addUser(null, (long[])new long[]{0L});
        PermissionChecker originalPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            searchContext.setUserId(user.getUserId());
            int baseModelsCount = initialBaseModelsSearchCount;
            if (addBaseModelPermission && !this.isCheckBaseModelPermission()) {
                ++baseModelsCount;
            }
            this.assertBaseModelsCount(baseModelsCount, searchContext);
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)originalPermissionChecker);
        }
        UserLocalServiceUtil.deleteUser((User)user);
    }

    protected BaseModel<?> updateBaseModel(BaseModel<?> baseModel, String keywords, ServiceContext serviceContext) throws Exception {
        return baseModel;
    }

    protected void updateDDMStructure(ServiceContext serviceContext) throws Exception {
    }
}

