/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.suggest;

import com.liferay.osgi.util.service.Snapshot;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.NGramHolder;
import com.liferay.portal.kernel.search.suggest.NGramHolderBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.solr8.internal.suggest.NGramQueryBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.osgi.service.component.annotations.Component;

@Component(service={NGramQueryBuilder.class})
public class NGramQueryBuilderImpl
implements NGramQueryBuilder {
    private static final String _OR_QUERY_SEPARATOR = " OR ";
    private static final Snapshot<NGramHolderBuilder> _nGramHolderBuilderSnapshot = new Snapshot(NGramQueryBuilderImpl.class, NGramHolderBuilder.class, null, true);

    @Override
    public SolrQuery getNGramQuery(String input) throws SearchException {
        SolrQuery solrQuery = new SolrQuery();
        NGramHolderBuilder nGramHolderBuilder = (NGramHolderBuilder)_nGramHolderBuilderSnapshot.get();
        if (nGramHolderBuilder == null) {
            return solrQuery;
        }
        StringBundler sb = new StringBundler();
        NGramHolder nGramHolder = nGramHolderBuilder.buildNGramHolder(input);
        Map nGrams = nGramHolder.getNGrams();
        this.addNGramsListQuery(sb, nGrams);
        if (!nGrams.isEmpty()) {
            this.addOrQuerySeparator(sb);
        }
        Map nGramEnds = nGramHolder.getNGramEnds();
        this.addNGramsQuery(sb, nGramEnds);
        if (!nGramEnds.isEmpty()) {
            this.addOrQuerySeparator(sb);
        }
        Map nGramStarts = nGramHolder.getNGramStarts();
        this.addNGramsQuery(sb, nGramStarts);
        if (!nGramStarts.isEmpty()) {
            this.addOrQuerySeparator(sb);
        }
        this.addQuery(sb, "spellCheckWord", input);
        solrQuery.setQuery(sb.toString());
        return solrQuery;
    }

    protected void addNGramsListQuery(StringBundler sb, Map<String, List<String>> nGrams) {
        Set<Map.Entry<String, List<String>>> set = nGrams.entrySet();
        Iterator<Map.Entry<String, List<String>>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> entry = iterator.next();
            String fieldName = entry.getKey();
            List<String> fieldValues = entry.getValue();
            Iterator<String> fieldValuesIterator = fieldValues.iterator();
            while (fieldValuesIterator.hasNext()) {
                this.addQuery(sb, fieldName, fieldValuesIterator.next());
                if (!fieldValuesIterator.hasNext() && !iterator.hasNext()) continue;
                this.addOrQuerySeparator(sb);
            }
        }
    }

    protected void addNGramsQuery(StringBundler sb, Map<String, String> nGrams) {
        Set<Map.Entry<String, String>> set = nGrams.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String fieldName = entry.getKey();
            String fieldValue = entry.getValue();
            this.addQuery(sb, fieldName, fieldValue);
            if (!iterator.hasNext()) continue;
            this.addOrQuerySeparator(sb);
        }
    }

    protected void addOrQuerySeparator(StringBundler sb) {
        sb.append(_OR_QUERY_SEPARATOR);
    }

    protected void addQuery(StringBundler sb, String name, String value) {
        sb.append(name);
        sb.append(":");
        value = QueryParser.escape((String)value);
        value = this._defuseUpperCaseLuceneBooleanOperators(value);
        value = this._encloseMultiword(value, "(", ")");
        sb.append(value);
    }

    private String _defuseUpperCaseLuceneBooleanOperators(String value) {
        return StringUtil.toLowerCase((String)value);
    }

    private String _encloseMultiword(String value, String open, String close) {
        if (value.indexOf(32) == -1) {
            return value;
        }
        return open + value + close;
    }
}

