/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.suggest;

import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.NGramHolder;
import com.liferay.portal.kernel.search.suggest.NGramHolderBuilder;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.osgi.service.component.annotations.Component;

@Component(service={NGramHolderBuilder.class})
public class NGramHolderBuilderImpl
implements NGramHolderBuilder {
    public NGramHolder buildNGramHolder(String input) throws SearchException {
        return this.buildNGramHolder(input, this.getNGramMinLength(input.length()), this.getNGramMaxLength(input.length()));
    }

    public NGramHolder buildNGramHolder(String input, int nGramMaxLength) throws SearchException {
        if (nGramMaxLength <= 0) {
            nGramMaxLength = this.getNGramMaxLength(input.length());
        }
        return this.buildNGramHolder(input, this.getNGramMinLength(input.length()), nGramMaxLength);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NGramHolder buildNGramHolder(String input, int nGramMinLength, int nGramMaxLength) throws SearchException {
        try (NGramTokenizer nGramTokenizer = this.createNGramTokenizer(nGramMinLength, nGramMaxLength);){
            nGramTokenizer.setReader((Reader)new StringReader(input));
            nGramTokenizer.reset();
            NGramHolder nGramHolder = new NGramHolder();
            CharTermAttribute charTermAttribute = (CharTermAttribute)nGramTokenizer.getAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAttribute = (OffsetAttribute)nGramTokenizer.getAttribute(OffsetAttribute.class);
            while (nGramTokenizer.incrementToken()) {
                String nGram = charTermAttribute.toString();
                int currentNGramLength = charTermAttribute.length();
                if (currentNGramLength < nGramMinLength || currentNGramLength > nGramMaxLength) continue;
                if (offsetAttribute.startOffset() == 0) {
                    nGramHolder.addNGramStart(currentNGramLength, nGram);
                    continue;
                }
                if (offsetAttribute.endOffset() == input.length()) {
                    nGramHolder.addNGramEnd(currentNGramLength, nGram);
                    continue;
                }
                nGramHolder.addNGram(currentNGramLength, nGram);
            }
            NGramHolder nGramHolder2 = nGramHolder;
            return nGramHolder2;
        }
        catch (Exception exception) {
            throw new SearchException((Throwable)exception);
        }
    }

    protected NGramTokenizer createNGramTokenizer(int nGramMinLength, int nGramMaxLength) {
        return new NGramTokenizer(nGramMinLength, nGramMaxLength){

            protected boolean isTokenChar(int c) {
                return !Character.isWhitespace(c);
            }
        };
    }

    protected int getNGramMaxLength(int length) {
        if (length > 5) {
            return 4;
        }
        if (length == 5) {
            return 3;
        }
        return 2;
    }

    protected int getNGramMinLength(int length) {
        if (length > 5) {
            return 3;
        }
        if (length == 5) {
            return 2;
        }
        return 1;
    }
}

